/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommentUtils {
    private static Pattern TAG_NAME_COMPILE = Pattern.compile("^@[\\w]+[\\t ]");

    public static String getTagType(String comment) {
        Matcher m = TAG_NAME_COMPILE.matcher(comment);
        if (m.find()) {
            return m.group().trim();
        }
        return null;
    }

    public static String parseCommentText(String comment) {
        List<String> comments = CommentUtils.asCommentList(comment);
        for (String s : comments) {
            if (s.startsWith("@")) continue;
            return s;
        }
        return "";
    }

    public static List<String> asCommentList(String comment) {
        comment = comment.replaceAll("\\*", "").trim();
        String[] array = comment.split("\n");
        ArrayList<String> comments = new ArrayList<String>(array.length);
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < array.length; ++index) {
            String c = array[index].trim();
            if (StringUtils.isBlank((CharSequence)c)) continue;
            String tagType = CommentUtils.getTagType(c);
            if (!StringUtils.isBlank((CharSequence)tagType)) break;
            sb.append(c);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            comments.add(sb.toString());
        }
        for (int i = index; i < array.length; ++i) {
            String c = array[i].trim();
            if (!StringUtils.isNotBlank((CharSequence)c)) continue;
            comments.add(c);
        }
        return comments;
    }
}

