/*
 * Decompiled with CFR 0.152.
 */
package io.github.yidasanqian.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class JsonUtil {
    public static final String JACKSON_CLASS_TYPE = "jackson";
    public static final String GSON_CLASS_TYPE = "gson";
    public static final String FASTJSON_CLASS_TYPE = "fastjson";
    private static final Logger log = Logger.getLogger("JsonUtil");
    private static final String CLASS_TYPE_OBJECT_MAPPER = "com.fasterxml.jackson.databind.ObjectMapper";
    private static final String CLASS_TYPE_GSON = "com.google.gson.Gson";
    private static final String CLASS_TYPE_FASTJSON = "com.alibaba.fastjson.JSON";
    public static String JSON_CLASS_TYPE = "json.class.type";
    public static Map<String, String> classTypeCache = new ConcurrentHashMap<String, String>();
    private static String classType;
    private static ObjectMapper objectMapper;
    private static Gson gson;

    public static Map toMap(String json) {
        Map result = null;
        try {
            switch (classType) {
                case "jackson": {
                    result = (Map)objectMapper.readValue(json, LinkedHashMap.class);
                    break;
                }
                case "gson": {
                    TypeToken<Map<Object, Object>> typeToken = new TypeToken<Map<Object, Object>>(){};
                    result = (Map)gson.fromJson(json, typeToken.getType());
                    break;
                }
                case "fastjson": {
                    result = (Map)JSON.parseObject((String)json, LinkedHashMap.class);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List toList(String json) {
        List result = null;
        try {
            switch (classType) {
                case "jackson": {
                    result = (List)objectMapper.readValue(json, LinkedList.class);
                    break;
                }
                case "gson": {
                    TypeToken<List<Object>> typeToken = new TypeToken<List<Object>>(){};
                    result = (List)gson.fromJson(json, typeToken.getType());
                    break;
                }
                case "fastjson": {
                    result = (List)JSON.parseObject((String)json, LinkedList.class);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T> List<T> toList(String json, final Type type) {
        List result = null;
        try {
            switch (classType) {
                case "jackson": {
                    TypeReference typeReference = new TypeReference<T>(){

                        public Type getType() {
                            return type;
                        }
                    };
                    result = (List)objectMapper.readValue(json, typeReference);
                    break;
                }
                case "gson": {
                    result = (List)gson.fromJson(json, type);
                    break;
                }
                case "fastjson": {
                    TypeReference typeReference1 = new TypeReference<T>(){

                        public Type getType() {
                            return type;
                        }
                    };
                    result = (List)JSON.parseObject((String)json, (Type)typeReference1.getType(), (Feature[])new Feature[0]);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String toJsonString(Object object) {
        String result = null;
        try {
            switch (classType) {
                case "jackson": {
                    result = objectMapper.writeValueAsString(object);
                    break;
                }
                case "gson": {
                    result = gson.toJson(object);
                    break;
                }
                case "fastjson": {
                    result = JSON.toJSONString((Object)object);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String toJsonWithDateFormat(Object object, String dateFormatPattern) {
        String result = null;
        try {
            switch (classType) {
                case "jackson": {
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormatPattern);
                    result = objectMapper.writer((DateFormat)sdf).writeValueAsString(object);
                    break;
                }
                case "gson": {
                    gson = new GsonBuilder().setDateFormat(dateFormatPattern).create();
                    result = gson.toJson(object);
                    break;
                }
                case "fastjson": {
                    result = JSON.toJSONStringWithDateFormat((Object)object, (String)dateFormatPattern, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T> T toPojo(String json, Class<T> valueType) {
        Object result = null;
        try {
            switch (classType) {
                case "jackson": {
                    result = objectMapper.readValue(json, valueType);
                    break;
                }
                case "gson": {
                    result = gson.fromJson(json, valueType);
                    break;
                }
                case "fastjson": {
                    result = JSON.parseObject((String)json, valueType);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static Map convertToMap(Object fromValue) {
        Map result = null;
        switch (classType) {
            case "jackson": {
                result = (Map)objectMapper.convertValue(fromValue, LinkedHashMap.class);
                break;
            }
            case "gson": {
                TypeToken<Map<Object, Object>> typeToken = new TypeToken<Map<Object, Object>>(){};
                String json = gson.toJson(fromValue);
                result = (Map)gson.fromJson(json, typeToken.getType());
                break;
            }
            case "fastjson": {
                String json = JSON.toJSONString((Object)fromValue);
                result = (Map)JSON.parseObject((String)json, LinkedHashMap.class);
                break;
            }
        }
        return result;
    }

    public static <T> T convertFromMap(Map fromMap, Class<T> toValueType) {
        Object result = null;
        switch (classType) {
            case "jackson": {
                result = objectMapper.convertValue((Object)fromMap, toValueType);
                break;
            }
            case "gson": {
                String json = gson.toJson((Object)fromMap);
                result = gson.fromJson(json, toValueType);
                break;
            }
            case "fastjson": {
                String json = JSON.toJSONString((Object)fromMap);
                result = JSON.parseObject((String)json, toValueType);
                break;
            }
        }
        return (T)result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            String jsonClassType;
            block20: {
                block21: {
                    block22: {
                        jsonClassType = null;
                        Properties properties = new Properties();
                        InputStream in = JsonUtil.class.getClassLoader().getResourceAsStream("application.properties");
                        if (in != null) {
                            properties.load(in);
                            jsonClassType = properties.getProperty(JSON_CLASS_TYPE);
                        } else {
                            log.warning("\u672a\u627e\u5230application.properties");
                            in = JsonUtil.class.getClassLoader().getResourceAsStream("application.yml");
                            if (in != null) {
                                Yaml yaml = new Yaml();
                                Map propsMap = (Map)yaml.loadAs(in, LinkedHashMap.class);
                                if ((propsMap = (Map)propsMap.get("json")) != null) {
                                    jsonClassType = String.valueOf(propsMap.get("class-type"));
                                } else {
                                    log.warning("application.yml\u4e2d\u672a\u914d\u7f6ejson.class-type");
                                }
                            } else {
                                log.warning("\u672a\u627e\u5230application.yml");
                            }
                        }
                        if (jsonClassType != null && jsonClassType.trim().length() > 0) {
                            classType = jsonClassType;
                        }
                        if (classType == null || classType.length() <= 0) break block21;
                        if (Class.forName(CLASS_TYPE_OBJECT_MAPPER) == null || !classType.equals(JACKSON_CLASS_TYPE)) break block22;
                        log.info("use jackson lib");
                        break block20;
                    }
                    if (Class.forName(CLASS_TYPE_GSON) != null && classType.equals(GSON_CLASS_TYPE)) {
                        log.info("use gson lib");
                        break block20;
                    } else if (Class.forName(CLASS_TYPE_FASTJSON) != null && classType.equals(FASTJSON_CLASS_TYPE)) {
                        log.info("use fastjson lib");
                        break block20;
                    } else {
                        log.severe("\u672a\u627e\u5230jackson\u3001gson\u6216fastjson\u7684\u4f9d\u8d56");
                        throw new RuntimeException("\u672a\u627e\u5230jackson\u3001gson\u6216fastjson\u7684\u4f9d\u8d56");
                    }
                }
                if (Class.forName(CLASS_TYPE_OBJECT_MAPPER) != null) {
                    log.info("use jackson lib");
                    classType = JACKSON_CLASS_TYPE;
                } else if (Class.forName(CLASS_TYPE_GSON) != null) {
                    log.info("use gson lib");
                    classType = GSON_CLASS_TYPE;
                } else {
                    if (Class.forName(CLASS_TYPE_FASTJSON) == null) {
                        log.severe("\u672a\u627e\u5230jackson\u3001gson\u6216fastjson\u7684\u4f9d\u8d56");
                        throw new RuntimeException("\u672a\u627e\u5230jackson\u3001gson\u6216fastjson\u7684\u4f9d\u8d56");
                    }
                    log.info("use fastjson lib");
                    classType = FASTJSON_CLASS_TYPE;
                }
            }
            classTypeCache.put(JSON_CLASS_TYPE, jsonClassType);
            if (objectMapper == null) {
                objectMapper = new ObjectMapper();
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
            if (gson != null) return;
            gson = new GsonBuilder().setLenient().registerTypeAdapter(new TypeToken<Map<Object, Object>>(){}.getType(), (Object)new JsonDeserializer<Map<Object, Object>>(){

                public Map<Object, Object> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    Set entrySet = jsonObject.entrySet();
                    for (Map.Entry entry : entrySet) {
                        Object obj = entry.getValue();
                        if (obj instanceof JsonPrimitive) {
                            map.put(entry.getKey(), ((JsonPrimitive)obj).getAsString());
                            continue;
                        }
                        map.put(entry.getKey(), obj);
                    }
                    return map;
                }
            }).registerTypeAdapter(new TypeToken<List<Object>>(){}.getType(), (Object)new JsonDeserializer<List<Object>>(){

                public List<Object> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    LinkedList<Object> list = new LinkedList<Object>();
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        if (jsonArray.get(i).isJsonObject()) {
                            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
                            Set entrySet = jsonObject.entrySet();
                            list.addAll(entrySet);
                            continue;
                        }
                        if (!jsonArray.get(i).isJsonPrimitive()) continue;
                        list.add(jsonArray.get(i));
                    }
                    return list;
                }
            }).create();
            return;
        }
        catch (IOException | ClassNotFoundException e) {
            log.severe(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

