/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.HttpClient;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.HttpProxy;
import java.io.IOException;

public class HttpClientDeserializer
extends StdScalarDeserializer<HttpClient> {
    public HttpClientDeserializer(Class<HttpClient> vc) {
        super(vc);
    }

    public HttpClient deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode httpClientSslOptionsNode;
        JsonNode httpClientOptionsNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpClient httpClient = new HttpClient();
        JsonNode httpProxyNode = node.get("http_proxy");
        if (httpProxyNode != null) {
            HttpProxy httpProxy = (HttpProxy)httpProxyNode.traverse(jp.getCodec()).readValueAs(HttpProxy.class);
            httpClient.setHttpProxy(httpProxy);
        }
        if ((httpClientOptionsNode = node.get("configuration")) != null) {
            HttpClientOptions httpClientOptions = (HttpClientOptions)httpClientOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientOptions.class);
            httpClient.setOptions(httpClientOptions);
        }
        if ((httpClientSslOptionsNode = node.get("ssl")) != null) {
            HttpClientSslOptions httpClientSslOptions = (HttpClientSslOptions)httpClientSslOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientSslOptions.class);
            httpClient.setSsl(httpClientSslOptions);
        }
        return httpClient;
    }
}

