/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.AbstractStdScalarDeserializer;
import io.gravitee.definition.model.HttpClientOptions;
import java.io.IOException;

public class HttpClientOptionsDeserializer
extends AbstractStdScalarDeserializer<HttpClientOptions> {
    public HttpClientOptionsDeserializer(Class<HttpClientOptions> vc) {
        super(vc);
    }

    public HttpClientOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        JsonNode connectTimeoutNode = node.get("connectTimeout");
        if (connectTimeoutNode != null) {
            long connectTimeout = connectTimeoutNode.asLong(HttpClientOptions.DEFAULT_CONNECT_TIMEOUT);
            httpClientOptions.setConnectTimeout(connectTimeout);
        } else {
            httpClientOptions.setConnectTimeout(HttpClientOptions.DEFAULT_CONNECT_TIMEOUT);
        }
        JsonNode readTimeoutNode = node.get("readTimeout");
        if (readTimeoutNode != null) {
            long readTimeout = readTimeoutNode.asLong(HttpClientOptions.DEFAULT_READ_TIMEOUT);
            httpClientOptions.setReadTimeout(readTimeout);
        } else {
            httpClientOptions.setReadTimeout(HttpClientOptions.DEFAULT_READ_TIMEOUT);
        }
        JsonNode idleTimeoutNode = node.get("idleTimeout");
        if (idleTimeoutNode != null) {
            long idleTimeout = idleTimeoutNode.asLong(HttpClientOptions.DEFAULT_IDLE_TIMEOUT);
            httpClientOptions.setIdleTimeout(idleTimeout);
        } else {
            httpClientOptions.setIdleTimeout(HttpClientOptions.DEFAULT_IDLE_TIMEOUT);
        }
        JsonNode keepAliveNode = node.get("keepAlive");
        if (keepAliveNode != null) {
            boolean keepAlive = keepAliveNode.asBoolean(HttpClientOptions.DEFAULT_KEEP_ALIVE);
            httpClientOptions.setKeepAlive(keepAlive);
        } else {
            httpClientOptions.setKeepAlive(HttpClientOptions.DEFAULT_KEEP_ALIVE);
        }
        JsonNode pipeliningNode = node.get("pipelining");
        if (pipeliningNode != null) {
            boolean pipelining = pipeliningNode.asBoolean(HttpClientOptions.DEFAULT_PIPELINING);
            httpClientOptions.setPipelining(pipelining);
        } else {
            httpClientOptions.setPipelining(HttpClientOptions.DEFAULT_PIPELINING);
        }
        JsonNode maxConcurrentConnectionsNode = node.get("maxConcurrentConnections");
        if (maxConcurrentConnectionsNode != null) {
            int maxConcurrentConnections = maxConcurrentConnectionsNode.asInt(HttpClientOptions.DEFAULT_MAX_CONCURRENT_CONNECTIONS);
            httpClientOptions.setMaxConcurrentConnections(maxConcurrentConnections);
        } else {
            httpClientOptions.setMaxConcurrentConnections(HttpClientOptions.DEFAULT_MAX_CONCURRENT_CONNECTIONS);
        }
        JsonNode useCompressionNode = node.get("useCompression");
        if (useCompressionNode != null) {
            boolean useCompression = useCompressionNode.asBoolean(HttpClientOptions.DEFAULT_USE_COMPRESSION);
            httpClientOptions.setUseCompression(useCompression);
        } else {
            httpClientOptions.setUseCompression(HttpClientOptions.DEFAULT_USE_COMPRESSION);
        }
        JsonNode followRedirectsNode = node.get("followRedirects");
        if (followRedirectsNode != null) {
            boolean useCompression = followRedirectsNode.asBoolean(HttpClientOptions.DEFAULT_FOLLOW_REDIRECTS);
            httpClientOptions.setFollowRedirects(useCompression);
        } else {
            httpClientOptions.setFollowRedirects(HttpClientOptions.DEFAULT_FOLLOW_REDIRECTS);
        }
        return httpClientOptions;
    }
}

