/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.ResponseTemplate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ResponseTemplateDeserializer
extends StdScalarDeserializer<ResponseTemplate> {
    public ResponseTemplateDeserializer(Class<ResponseTemplate> vc) {
        super(vc);
    }

    public ResponseTemplate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Map headers;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ResponseTemplate template = new ResponseTemplate();
        template.setStatusCode(node.path("status").asInt());
        template.setBody(node.path("body").asText());
        JsonNode headersNode = node.get("headers");
        if (headersNode != null && !headersNode.isEmpty(null) && (headers = (Map)headersNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, String>>(){})) != null && !headers.isEmpty()) {
            if (template.getHeaders() == null) {
                template.setHeaders(headers);
            } else {
                headers.forEach(template.getHeaders()::putIfAbsent);
            }
        }
        return template;
    }
}

