/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.plugins.resources.Resource;
import java.io.IOException;

public class ApiSerializer
extends StdScalarSerializer<Api> {
    public ApiSerializer(Class<Api> t) {
        super(t);
    }

    public void serialize(Api api, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("id", api.getId());
        jgen.writeStringField("name", api.getName());
        jgen.writeObjectField("version", (Object)api.getVersion());
        if (api.getProxy() != null) {
            jgen.writeObjectField("proxy", (Object)api.getProxy());
        }
        if (api.getPaths() != null) {
            jgen.writeObjectFieldStart("paths");
            api.getPaths().forEach((s, path) -> {
                try {
                    jgen.writeObjectField(s, path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndObject();
        }
        if (api.getServices() != null && !api.getServices().isEmpty()) {
            jgen.writeObjectField("services", (Object)api.getServices());
        }
        if (api.getResources() != null && !api.getResources().isEmpty()) {
            jgen.writeArrayFieldStart("resources");
            for (Resource resource : api.getResources()) {
                jgen.writeObject((Object)resource);
            }
            jgen.writeEndArray();
        }
        if (api.getProperties() != null && api.getProperties().getValues() != null) {
            jgen.writeObjectField("properties", (Object)api.getProperties());
        }
        if (api.getTags() != null && !api.getTags().isEmpty()) {
            jgen.writeArrayFieldStart("tags");
            api.getTags().forEach(tag -> {
                try {
                    jgen.writeObject(tag);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (api.getPathMappings() != null && !api.getPathMappings().isEmpty()) {
            jgen.writeArrayFieldStart("path_mappings");
            api.getPathMappings().keySet().forEach(pathMapping -> {
                try {
                    jgen.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (api.getResponseTemplates() != null && !api.getResponseTemplates().isEmpty()) {
            jgen.writeObjectField("response_templates", (Object)api.getResponseTemplates());
        }
        jgen.writeEndObject();
    }
}

