/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.Proxy;
import java.io.IOException;
import java.util.Set;

public class ProxySerializer
extends StdScalarSerializer<Proxy> {
    public ProxySerializer(Class<Proxy> t) {
        super(t);
    }

    public void serialize(Proxy proxy, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Set groups;
        jgen.writeStartObject();
        if (proxy.getVirtualHosts() != null) {
            jgen.writeArrayFieldStart("virtual_hosts");
            proxy.getVirtualHosts().forEach(vhost -> {
                try {
                    jgen.writeObject(vhost);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        jgen.writeBooleanField("strip_context_path", proxy.isStripContextPath());
        jgen.writeBooleanField("preserve_host", proxy.isPreserveHost());
        if (proxy.getLogging() != null) {
            jgen.writeObjectField("logging", (Object)proxy.getLogging());
        }
        if ((groups = proxy.getGroups()) != null) {
            jgen.writeArrayFieldStart("groups");
            groups.forEach(group -> {
                try {
                    jgen.writeObject(group);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (proxy.getFailover() != null) {
            jgen.writeObjectField("failover", (Object)proxy.getFailover());
        }
        if (proxy.getCors() != null && proxy.getCors().isEnabled()) {
            jgen.writeObjectField("cors", (Object)proxy.getCors());
        }
        jgen.writeEndObject();
    }
}

