/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.Rule;
import java.io.IOException;

public class RuleSerializer
extends StdScalarSerializer<Rule> {
    public RuleSerializer(Class<Rule> t) {
        super(t);
    }

    public void serialize(Rule rule, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (rule.getPolicy() != null) {
            jgen.writeStartObject();
            jgen.writeFieldName("methods");
            jgen.writeStartArray();
            for (HttpMethod method : rule.getMethods()) {
                jgen.writeString(method.toString().toUpperCase());
            }
            jgen.writeEndArray();
            jgen.writeObject((Object)rule.getPolicy());
            if (rule.getDescription() != null) {
                jgen.writeStringField("description", rule.getDescription());
            }
            jgen.writeBooleanField("enabled", rule.isEnabled());
            jgen.writeEndObject();
        }
    }
}

