/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.core.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.services.core.deser.ServiceDeserializer;
import io.gravitee.definition.model.services.schedule.ScheduledService;
import io.gravitee.definition.model.services.schedule.Trigger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class ScheduledServiceDeserializer<T extends ScheduledService>
extends ServiceDeserializer<T> {
    public ScheduledServiceDeserializer(Class<T> vc) {
        super(vc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void deserialize(T service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        super.deserialize(service, jsonParser, node, ctxt);
        if (!service.isEnabled()) return;
        Trigger trigger = new Trigger();
        JsonNode triggerNode = node.get("trigger");
        if (triggerNode != null) {
            JsonNode rateNode = triggerNode.get("rate");
            if (rateNode == null) {
                throw ctxt.mappingException("[scheduled-service] Rate is required");
            }
            trigger.setRate(rateNode.asLong());
            JsonNode unitNode = triggerNode.get("unit");
            if (unitNode == null) throw ctxt.mappingException("[scheduled-service] Unit is required");
            trigger.setUnit(TimeUnit.valueOf(unitNode.asText().toUpperCase()));
        } else {
            JsonNode intervalNode = node.get("interval");
            if (intervalNode == null) {
                throw ctxt.mappingException("[scheduled-service] Interval is required");
            }
            trigger.setRate(intervalNode.asLong());
            JsonNode unitNode = node.get("unit");
            if (unitNode == null) throw ctxt.mappingException("[scheduled-service] Unit is required");
            trigger.setUnit(TimeUnit.valueOf(unitNode.asText().toUpperCase()));
        }
        service.setTrigger(trigger);
    }
}

