/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.dynamicproperty.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.services.core.deser.ScheduledServiceDeserializer;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProviderConfiguration;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import java.io.IOException;

public class DynamicPropertyDeserializer
extends ScheduledServiceDeserializer<DynamicPropertyService> {
    public DynamicPropertyDeserializer(Class<DynamicPropertyService> vc) {
        super(vc);
    }

    @Override
    protected void deserialize(DynamicPropertyService service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        super.deserialize(service, jsonParser, node, ctxt);
        JsonNode providerNode = node.get("provider");
        if (providerNode == null) {
            throw ctxt.mappingException("[dynamic-property] Provider is required");
        }
        service.setProvider(DynamicPropertyProvider.valueOf((String)providerNode.asText().toUpperCase()));
        JsonNode configurationNode = node.get("configuration");
        if (service.getProvider() == DynamicPropertyProvider.HTTP) {
            HttpDynamicPropertyProviderConfiguration configuration = (HttpDynamicPropertyProviderConfiguration)configurationNode.traverse(jsonParser.getCodec()).readValueAs(HttpDynamicPropertyProviderConfiguration.class);
            service.setConfiguration((DynamicPropertyProviderConfiguration)configuration);
        }
    }
}

