/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.services.core.deser.ScheduledServiceDeserializer;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.definition.model.services.healthcheck.Request;
import io.gravitee.definition.model.services.healthcheck.Response;
import io.gravitee.definition.model.services.healthcheck.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class HealthCheckDeserializer<T extends HealthCheckService>
extends ScheduledServiceDeserializer<T> {
    public HealthCheckDeserializer(Class<T> vc) {
        super(vc);
    }

    @Override
    protected void deserialize(T service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        super.deserialize(service, jsonParser, node, ctxt);
        if (service.isEnabled()) {
            JsonNode stepsNode = node.get("steps");
            if (stepsNode != null && stepsNode.isArray()) {
                ArrayList<Step> steps = new ArrayList<Step>(stepsNode.size());
                for (JsonNode stepNode : stepsNode) {
                    Step step = (Step)stepNode.traverse(jsonParser.getCodec()).readValueAs(Step.class);
                    steps.add(step);
                }
                service.setSteps(steps);
            } else {
                Step step = new Step();
                JsonNode requestNode = node.get("request");
                if (requestNode == null) {
                    throw ctxt.mappingException("[health-check] Request is required");
                }
                step.setRequest((Request)requestNode.traverse(jsonParser.getCodec()).readValueAs(Request.class));
                JsonNode expectationNode = node.get("expectation");
                if (expectationNode != null) {
                    step.setResponse((Response)expectationNode.traverse(jsonParser.getCodec()).readValueAs(Response.class));
                } else {
                    Response response = new Response();
                    response.setAssertions(Collections.singletonList("#response.status == 200"));
                    step.setResponse(response);
                }
                service.setSteps(Collections.singletonList(step));
            }
        }
    }
}

