/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.services.healthcheck.Request;
import io.gravitee.definition.model.services.healthcheck.Response;
import io.gravitee.definition.model.services.healthcheck.Step;
import java.io.IOException;
import java.util.Collections;

public class StepDeserializer
extends StdScalarDeserializer<Step> {
    public StepDeserializer(Class<Step> vc) {
        super(vc);
    }

    public Step deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Step step = new Step();
        JsonNode requestNode = node.get("request");
        if (requestNode == null) {
            throw ctxt.mappingException("[health-check] Step request is required");
        }
        step.setRequest((Request)requestNode.traverse(jsonParser.getCodec()).readValueAs(Request.class));
        JsonNode responseNode = node.get("response");
        if (responseNode != null) {
            step.setResponse((Response)responseNode.traverse(jsonParser.getCodec()).readValueAs(Response.class));
        } else {
            Response response = new Response();
            response.setAssertions(Collections.singletonList("#response.status == 200"));
            step.setResponse(response);
        }
        JsonNode nameNode = node.get("name");
        if (nameNode != null) {
            step.setName(nameNode.asText());
        } else {
            step.setName("default-step");
        }
        return step;
    }
}

