/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.services.healthcheck.Request;
import java.io.IOException;

public class RequestSerializer
extends StdScalarSerializer<Request> {
    public RequestSerializer(Class<Request> t) {
        super(t);
    }

    public void serialize(Request request, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("path", request.getPath());
        jgen.writeStringField("method", request.getMethod().name());
        if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
            jgen.writeArrayFieldStart("headers");
            request.getHeaders().forEach(httpHeader -> {
                try {
                    jgen.writeStartObject();
                    jgen.writeStringField("name", httpHeader.getName());
                    jgen.writeStringField("value", httpHeader.getValue());
                    jgen.writeEndObject();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (request.getBody() != null && !request.getBody().isEmpty()) {
            jgen.writeStringField("body", request.getBody());
        }
        jgen.writeBooleanField("fromRoot", request.isFromRoot());
        jgen.writeEndObject();
    }
}

