/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.proxy.ws;

import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.builder.ProxyRequestImpl;
import io.gravitee.gateway.api.proxy.ws.WebSocketProxyRequest;
import io.gravitee.gateway.api.ws.WebSocket;
import io.gravitee.gateway.api.ws.WebSocketFrame;
import io.gravitee.reporter.api.http.Metrics;

public class WebSocketProxyRequestImpl
extends ProxyRequestImpl
implements WebSocketProxyRequest {
    private final WebSocket websocket;

    public WebSocketProxyRequestImpl(WebSocket websocket, Metrics metrics) {
        super(metrics);
        this.websocket = websocket;
    }

    @Override
    public WebSocketProxyRequest upgrade() {
        this.websocket.upgrade();
        return this;
    }

    @Override
    public WebSocketProxyRequest reject(int statusCode) {
        this.websocket.reject(statusCode);
        return this;
    }

    @Override
    public WebSocketProxyRequest write(WebSocketFrame frame) {
        this.websocket.write(frame);
        return this;
    }

    @Override
    public WebSocketProxyRequest close() {
        this.websocket.close();
        return this;
    }

    @Override
    public WebSocketProxyRequest frameHandler(Handler<WebSocketFrame> handler) {
        this.websocket.frameHandler(handler);
        return this;
    }

    @Override
    public WebSocketProxyRequest closeHandler(Handler<Void> handler) {
        this.websocket.closeHandler(handler);
        return this;
    }

    @Override
    public boolean isWebSocket() {
        return true;
    }
}

