/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugins.service.handler;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.plugins.service.ServiceManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextFactory;
import io.gravitee.plugin.core.api.PluginHandler;
import io.gravitee.plugin.core.api.PluginType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ServicePluginHandler
implements PluginHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicePluginHandler.class);
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private PluginContextFactory pluginContextFactory;
    @Autowired
    private PluginClassLoaderFactory pluginClassLoaderFactory;

    public boolean canHandle(Plugin plugin) {
        return plugin.type() == PluginType.SERVICE;
    }

    public void handle(Plugin plugin) {
        try {
            this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, this.getClass().getClassLoader());
            LOGGER.info("Register a new service: {} [{}]", (Object)plugin.id(), (Object)plugin.clazz());
            ApplicationContext context = this.pluginContextFactory.create(plugin);
            this.serviceManager.register((AbstractService)context.getBean(plugin.clazz()));
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while create reporter instance", (Throwable)iae);
            this.pluginContextFactory.remove(plugin);
        }
    }
}

