/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugins.service.impl;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.plugins.service.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagerImpl
extends AbstractService
implements ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManagerImpl.class);
    private final List<AbstractService> services = new ArrayList<AbstractService>();

    @Override
    public void register(AbstractService service) {
        this.services.add(service);
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (AbstractService service : this.services) {
            try {
                service.start();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while starting service", (Throwable)ex);
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (AbstractService service : this.services) {
            try {
                service.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while stopping service", (Throwable)ex);
            }
        }
    }

    protected String name() {
        return "Plugins - Services Manager";
    }
}

