/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Converter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.lookup.v1.RouteLookupRequest;
import io.grpc.lookup.v1.RouteLookupResponse;
import io.grpc.lookup.v1.RouteLookupServiceGrpc;
import io.grpc.rls.ChildLoadBalancerHelper;
import io.grpc.rls.LbPolicyConfiguration;
import io.grpc.rls.LinkedHashLruCache;
import io.grpc.rls.LruCache;
import io.grpc.rls.ResolvedAddressFactory;
import io.grpc.rls.RlsProtoConverters;
import io.grpc.rls.RlsProtoData;
import io.grpc.rls.RlsRequestFactory;
import io.grpc.rls.SubchannelStateManagerImpl;
import io.grpc.rls.Throttler;
import io.grpc.stub.StreamObserver;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CachingRlsLbClient {
    private static final Converter<RlsProtoData.RouteLookupRequest, RouteLookupRequest> REQUEST_CONVERTER = new RlsProtoConverters.RouteLookupRequestConverter().reverse();
    private static final Converter<RlsProtoData.RouteLookupResponse, RouteLookupResponse> RESPONSE_CONVERTER = new RlsProtoConverters.RouteLookupResponseConverter().reverse();
    public static final long MIN_EVICTION_TIME_DELTA_NANOS = TimeUnit.SECONDS.toNanos(5L);
    public static final int BYTES_PER_CHAR = 2;
    public static final int STRING_OVERHEAD_BYTES = 38;
    public static final int OBJ_OVERHEAD_B = 16;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final RlsAsyncLruCache linkedHashLruCache;
    @GuardedBy(value="lock")
    private final Map<RlsProtoData.RouteLookupRequest, PendingCacheEntry> pendingCallCache = new HashMap<RlsProtoData.RouteLookupRequest, PendingCacheEntry>();
    private final SynchronizationContext synchronizationContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Ticker ticker;
    private final Throttler throttler;
    private final LbPolicyConfiguration lbPolicyConfig;
    private final BackoffPolicy.Provider backoffProvider;
    private final long maxAgeNanos;
    private final long staleAgeNanos;
    private final long callTimeoutNanos;
    private final RlsLbHelper helper;
    private final ManagedChannel rlsChannel;
    private final RouteLookupServiceGrpc.RouteLookupServiceStub rlsStub;
    private final RlsPicker rlsPicker;
    private final ResolvedAddressFactory childLbResolvedAddressFactory;
    private final LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory refCountedChildPolicyWrapperFactory;
    private final ChannelLogger logger;
    @VisibleForTesting
    static final Metadata.Key<String> RLS_DATA_KEY = Metadata.Key.of((String)"X-Google-RLS-Data", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private CachingRlsLbClient(Builder builder) {
        this.helper = new RlsLbHelper((LoadBalancer.Helper)Preconditions.checkNotNull((Object)builder.helper, (Object)"helper"));
        this.scheduledExecutorService = this.helper.getScheduledExecutorService();
        this.synchronizationContext = this.helper.getSynchronizationContext();
        this.lbPolicyConfig = (LbPolicyConfiguration)Preconditions.checkNotNull((Object)builder.lbPolicyConfig, (Object)"lbPolicyConfig");
        RlsProtoData.RouteLookupConfig rlsConfig = this.lbPolicyConfig.getRouteLookupConfig();
        this.maxAgeNanos = rlsConfig.maxAgeInNanos();
        this.staleAgeNanos = rlsConfig.staleAgeInNanos();
        this.callTimeoutNanos = rlsConfig.lookupServiceTimeoutInNanos();
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)builder.ticker, (Object)"ticker");
        this.throttler = (Throttler)Preconditions.checkNotNull((Object)builder.throttler, (Object)"throttler");
        this.linkedHashLruCache = new RlsAsyncLruCache(rlsConfig.cacheSizeBytes(), builder.evictionListener, this.scheduledExecutorService, this.ticker, this.lock);
        this.logger = this.helper.getChannelLogger();
        String serverHost = null;
        try {
            serverHost = new URI(null, this.helper.getAuthority(), null, null, null).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (serverHost == null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Can not get hostname from authority: {0}", new Object[]{this.helper.getAuthority()});
            serverHost = this.helper.getAuthority();
        }
        RlsRequestFactory requestFactory = new RlsRequestFactory(this.lbPolicyConfig.getRouteLookupConfig(), serverHost);
        this.rlsPicker = new RlsPicker(requestFactory);
        ManagedChannelBuilder rlsChannelBuilder = this.helper.createResolvingOobChannelBuilder(rlsConfig.lookupService(), this.helper.getUnsafeChannelCredentials());
        rlsChannelBuilder.overrideAuthority(this.helper.getAuthority());
        Map<String, ?> routeLookupChannelServiceConfig = this.lbPolicyConfig.getRouteLookupChannelServiceConfig();
        if (routeLookupChannelServiceConfig != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS channel service config: {0}", new Object[]{routeLookupChannelServiceConfig});
            rlsChannelBuilder.defaultServiceConfig(routeLookupChannelServiceConfig);
            rlsChannelBuilder.disableServiceConfigLookUp();
        }
        this.rlsChannel = rlsChannelBuilder.build();
        this.helper.updateBalancingState(ConnectivityState.CONNECTING, this.rlsPicker);
        this.rlsStub = RouteLookupServiceGrpc.newStub((Channel)this.rlsChannel);
        this.childLbResolvedAddressFactory = (ResolvedAddressFactory)Preconditions.checkNotNull((Object)builder.resolvedAddressFactory, (Object)"resolvedAddressFactory");
        this.backoffProvider = builder.backoffProvider;
        ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider = new ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider((LoadBalancer.Helper)this.helper, new SubchannelStateManagerImpl(), this.rlsPicker);
        this.refCountedChildPolicyWrapperFactory = new LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory(this.lbPolicyConfig.getLoadBalancingPolicy(), this.childLbResolvedAddressFactory, childLbHelperProvider, new BackoffRefreshListener());
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient created");
    }

    static Status convertRlsServerStatus(Status status, String serverName) {
        return Status.UNAVAILABLE.withCause(status.getCause()).withDescription(String.format("Unable to retrieve RLS targets from RLS server %s.  RLS server returned: %s: %s", serverName, status.getCode(), status.getDescription()));
    }

    @CheckReturnValue
    private ListenableFuture<RlsProtoData.RouteLookupResponse> asyncRlsCall(RlsProtoData.RouteLookupRequest request) {
        final SettableFuture response = SettableFuture.create();
        if (this.throttler.shouldThrottle()) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Request is throttled");
            response.setException((Throwable)new Throttler.ThrottledException());
            return response;
        }
        RouteLookupRequest routeLookupRequest = (RouteLookupRequest)REQUEST_CONVERTER.convert((Object)request);
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Sending RouteLookupRequest: {0}", new Object[]{routeLookupRequest});
        ((RouteLookupServiceGrpc.RouteLookupServiceStub)this.rlsStub.withDeadlineAfter(this.callTimeoutNanos, TimeUnit.NANOSECONDS)).routeLookup(routeLookupRequest, new StreamObserver<RouteLookupResponse>(){

            public void onNext(RouteLookupResponse value) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received RouteLookupResponse: {0}", new Object[]{value});
                response.set((Object)((RlsProtoData.RouteLookupResponse)RESPONSE_CONVERTER.reverse().convert((Object)value)));
            }

            public void onError(Throwable t) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Error looking up route:", new Object[]{t});
                response.setException(t);
                CachingRlsLbClient.this.throttler.registerBackendResponse(false);
                CachingRlsLbClient.this.helper.propagateRlsError();
            }

            public void onCompleted() {
                CachingRlsLbClient.this.throttler.registerBackendResponse(true);
            }
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    final CachedRouteLookupResponse get(RlsProtoData.RouteLookupRequest request) {
        Object object = this.lock;
        synchronized (object) {
            CacheEntry cacheEntry = (CacheEntry)this.linkedHashLruCache.read(request);
            if (cacheEntry == null) {
                return this.handleNewRequest(request);
            }
            if (cacheEntry instanceof DataCacheEntry) {
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Cache hit for the request");
                DataCacheEntry dataEntry = (DataCacheEntry)cacheEntry;
                if (dataEntry.isStaled(this.ticker.read())) {
                    dataEntry.maybeRefresh();
                }
                return CachedRouteLookupResponse.dataEntry((DataCacheEntry)cacheEntry);
            }
            return CachedRouteLookupResponse.backoffEntry((BackoffCacheEntry)cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient closed");
        Object object = this.lock;
        synchronized (object) {
            this.linkedHashLruCache.close();
            this.pendingCallCache.clear();
            this.rlsChannel.shutdownNow();
            this.rlsPicker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedRouteLookupResponse handleNewRequest(RlsProtoData.RouteLookupRequest request) {
        Object object = this.lock;
        synchronized (object) {
            PendingCacheEntry pendingEntry = this.pendingCallCache.get(request);
            if (pendingEntry != null) {
                return CachedRouteLookupResponse.pendingResponse(pendingEntry);
            }
            ListenableFuture<RlsProtoData.RouteLookupResponse> asyncCall = this.asyncRlsCall(request);
            if (!asyncCall.isDone()) {
                pendingEntry = new PendingCacheEntry(request, asyncCall);
                this.pendingCallCache.put(request, pendingEntry);
                return CachedRouteLookupResponse.pendingResponse(pendingEntry);
            }
            try {
                RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)asyncCall.get();
                DataCacheEntry dataEntry = new DataCacheEntry(request, response);
                this.linkedHashLruCache.cacheAndClean(request, dataEntry);
                return CachedRouteLookupResponse.dataEntry(dataEntry);
            }
            catch (Exception e) {
                BackoffCacheEntry backoffEntry = new BackoffCacheEntry(request, Status.fromThrowable((Throwable)e), this.backoffProvider.get());
                this.linkedHashLruCache.cacheAndClean(request, backoffEntry);
                return CachedRouteLookupResponse.backoffEntry(backoffEntry);
            }
        }
    }

    void requestConnection() {
        this.rlsChannel.getState(true);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    final class RlsPicker
    extends LoadBalancer.SubchannelPicker {
        private final RlsRequestFactory requestFactory;
        private LbPolicyConfiguration.ChildPolicyWrapper fallbackChildPolicyWrapper;

        RlsPicker(RlsRequestFactory requestFactory) {
            this.requestFactory = (RlsRequestFactory)Preconditions.checkNotNull((Object)requestFactory, (Object)"requestFactory");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            String defaultTarget;
            boolean hasFallback;
            String serviceName = args.getMethodDescriptor().getServiceName();
            String methodName = args.getMethodDescriptor().getBareMethodName();
            RlsProtoData.RouteLookupRequest request = this.requestFactory.create(serviceName, methodName, args.getHeaders());
            CachedRouteLookupResponse response = CachingRlsLbClient.this.get(request);
            CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Got route lookup cache entry for service={0}, method={1}, headers={2}:\n {3}", new Object[]{serviceName, methodName, args.getHeaders(), response});
            if (response.getHeaderData() != null && !response.getHeaderData().isEmpty()) {
                Metadata headers = args.getHeaders();
                headers.discardAll(RLS_DATA_KEY);
                headers.put(RLS_DATA_KEY, (Object)response.getHeaderData());
            }
            boolean bl = hasFallback = (defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().defaultTarget()) != null && !defaultTarget.isEmpty();
            if (response.hasData()) {
                LoadBalancer.SubchannelPicker picker;
                LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper = response.getChildPolicyWrapper();
                LoadBalancer.SubchannelPicker subchannelPicker = picker = childPolicyWrapper != null ? childPolicyWrapper.getPicker() : null;
                if (picker == null) {
                    return LoadBalancer.PickResult.withNoResult();
                }
                return picker.pickSubchannel(args);
            }
            if (response.hasError()) {
                if (hasFallback) {
                    return this.useFallback(args);
                }
                return LoadBalancer.PickResult.withError((Status)CachingRlsLbClient.convertRlsServerStatus(response.getStatus(), CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().lookupService()));
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        private LoadBalancer.PickResult useFallback(LoadBalancer.PickSubchannelArgs args) {
            this.startFallbackChildPolicy();
            LoadBalancer.SubchannelPicker picker = this.fallbackChildPolicyWrapper.getPicker();
            if (picker == null) {
                return LoadBalancer.PickResult.withNoResult();
            }
            return picker.pickSubchannel(args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFallbackChildPolicy() {
            String defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().defaultTarget();
            CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "starting fallback to {0}", new Object[]{defaultTarget});
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.fallbackChildPolicyWrapper != null) {
                    return;
                }
                this.fallbackChildPolicyWrapper = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet(defaultTarget);
            }
        }

        void close() {
            if (this.fallbackChildPolicyWrapper != null) {
                CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(this.fallbackChildPolicyWrapper);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("target", (Object)CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().lookupService()).toString();
        }
    }

    private final class BackoffRefreshListener
    implements LbPolicyConfiguration.ChildLbStatusListener {
        @Nullable
        private ConnectivityState prevState = null;

        private BackoffRefreshListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(ConnectivityState newState) {
            if (this.prevState == ConnectivityState.TRANSIENT_FAILURE && newState == ConnectivityState.READY) {
                Object object = CachingRlsLbClient.this.lock;
                synchronized (object) {
                    for (CacheEntry value : CachingRlsLbClient.this.linkedHashLruCache.values()) {
                        if (!(value instanceof BackoffCacheEntry)) continue;
                        ((BackoffCacheEntry)value).forceRefresh();
                    }
                }
            }
            this.prevState = newState;
        }
    }

    private static final class RlsAsyncLruCache
    extends LinkedHashLruCache<RlsProtoData.RouteLookupRequest, CacheEntry> {
        RlsAsyncLruCache(long maxEstimatedSizeBytes, @Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener, ScheduledExecutorService ses, Ticker ticker, Object lock) {
            super(maxEstimatedSizeBytes, new AutoCleaningEvictionListener(evictionListener), 1, TimeUnit.MINUTES, ses, ticker, lock);
        }

        @Override
        protected boolean isExpired(RlsProtoData.RouteLookupRequest key, CacheEntry value, long nowNanos) {
            return value.isExpired();
        }

        @Override
        protected int estimateSizeOf(RlsProtoData.RouteLookupRequest key, CacheEntry value) {
            return value.getSizeBytes();
        }

        @Override
        protected boolean shouldInvalidateEldestEntry(RlsProtoData.RouteLookupRequest eldestKey, CacheEntry eldestValue) {
            if (eldestValue.getMinEvictionTime() > this.now()) {
                return false;
            }
            return this.estimatedSizeBytes() > this.estimatedMaxSizeBytes();
        }

        public CacheEntry cacheAndClean(RlsProtoData.RouteLookupRequest key, CacheEntry value) {
            CacheEntry newEntry = this.cache(key, value);
            if (this.fitToLimit()) {
                value.triggerPendingRpcProcessing();
            }
            return newEntry;
        }
    }

    private static final class HappyThrottler
    implements Throttler {
        private HappyThrottler() {
        }

        @Override
        public boolean shouldThrottle() {
            return false;
        }

        @Override
        public void registerBackendResponse(boolean throttled) {
        }
    }

    private static final class AutoCleaningEvictionListener
    implements LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> {
        private final LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate;

        AutoCleaningEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEviction(RlsProtoData.RouteLookupRequest key, CacheEntry value, LruCache.EvictionType cause) {
            if (this.delegate != null) {
                this.delegate.onEviction(key, value, cause);
            }
            value.cleanup();
        }
    }

    static final class Builder {
        private LoadBalancer.Helper helper;
        private LbPolicyConfiguration lbPolicyConfig;
        private Throttler throttler = new HappyThrottler();
        private ResolvedAddressFactory resolvedAddressFactory;
        private Ticker ticker = Ticker.systemTicker();
        private LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener;
        private BackoffPolicy.Provider backoffProvider = new ExponentialBackoffPolicy.Provider();

        Builder() {
        }

        Builder setHelper(LoadBalancer.Helper helper) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            return this;
        }

        Builder setLbPolicyConfig(LbPolicyConfiguration lbPolicyConfig) {
            this.lbPolicyConfig = (LbPolicyConfiguration)Preconditions.checkNotNull((Object)lbPolicyConfig, (Object)"lbPolicyConfig");
            return this;
        }

        Builder setThrottler(Throttler throttler) {
            this.throttler = (Throttler)Preconditions.checkNotNull((Object)throttler, (Object)"throttler");
            return this;
        }

        Builder setResolvedAddressesFactory(ResolvedAddressFactory resolvedAddressFactory) {
            this.resolvedAddressFactory = (ResolvedAddressFactory)Preconditions.checkNotNull((Object)resolvedAddressFactory, (Object)"resolvedAddressFactory");
            return this;
        }

        Builder setTicker(Ticker ticker) {
            this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
            return this;
        }

        Builder setEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener) {
            this.evictionListener = evictionListener;
            return this;
        }

        Builder setBackoffProvider(BackoffPolicy.Provider provider) {
            this.backoffProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
            return this;
        }

        CachingRlsLbClient build() {
            return new CachingRlsLbClient(this);
        }
    }

    private final class BackoffCacheEntry
    extends CacheEntry {
        private final Status status;
        private final SynchronizationContext.ScheduledHandle scheduledHandle;
        private final BackoffPolicy backoffPolicy;
        private final long expireNanos;
        private boolean shutdown;

        BackoffCacheEntry(RlsProtoData.RouteLookupRequest request, Status status, BackoffPolicy backoffPolicy) {
            super(request);
            this.shutdown = false;
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.backoffPolicy = (BackoffPolicy)Preconditions.checkNotNull((Object)backoffPolicy, (Object)"backoffPolicy");
            long delayNanos = backoffPolicy.nextBackoffNanos();
            this.expireNanos = CachingRlsLbClient.this.ticker.read() + delayNanos;
            this.scheduledHandle = CachingRlsLbClient.this.synchronizationContext.schedule(new Runnable(){

                @Override
                public void run() {
                    BackoffCacheEntry.this.transitionToPending();
                }
            }, delayNanos, TimeUnit.NANOSECONDS, CachingRlsLbClient.this.scheduledExecutorService);
        }

        void forceRefresh() {
            if (this.scheduledHandle.isPending()) {
                this.scheduledHandle.cancel();
                this.transitionToPending();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToPending() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    return;
                }
                ListenableFuture call = CachingRlsLbClient.this.asyncRlsCall(this.request);
                if (!call.isDone()) {
                    PendingCacheEntry pendingEntry = new PendingCacheEntry(this.request, (ListenableFuture<RlsProtoData.RouteLookupResponse>)call, this.backoffPolicy);
                    CachingRlsLbClient.this.pendingCallCache.put(this.request, pendingEntry);
                    CachingRlsLbClient.this.linkedHashLruCache.invalidate(this.request);
                } else {
                    try {
                        RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)call.get();
                        CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, new DataCacheEntry(this.request, response));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, new BackoffCacheEntry(this.request, Status.fromThrowable((Throwable)e), this.backoffPolicy));
                    }
                }
            }
        }

        Status getStatus() {
            return this.status;
        }

        @Override
        int getSizeBytes() {
            return 120;
        }

        @Override
        boolean isExpired(long now) {
            return this.expireNanos - now <= 0L;
        }

        @Override
        void cleanup() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            if (!this.scheduledHandle.isPending()) {
                this.scheduledHandle.cancel();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("status", (Object)this.status).toString();
        }
    }

    final class DataCacheEntry
    extends CacheEntry {
        private final RlsProtoData.RouteLookupResponse response;
        private final long minEvictionTime;
        private final long expireTime;
        private final long staleTime;
        private final List<LbPolicyConfiguration.ChildPolicyWrapper> childPolicyWrappers;

        DataCacheEntry(RlsProtoData.RouteLookupRequest request, RlsProtoData.RouteLookupResponse response) {
            super(request);
            this.response = (RlsProtoData.RouteLookupResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
            Preconditions.checkState((!response.targets().isEmpty() ? 1 : 0) != 0, (Object)"No targets returned by RLS");
            this.childPolicyWrappers = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet((List<String>)response.targets());
            long now = CachingRlsLbClient.this.ticker.read();
            this.minEvictionTime = now + MIN_EVICTION_TIME_DELTA_NANOS;
            this.expireTime = now + CachingRlsLbClient.this.maxAgeNanos;
            this.staleTime = now + CachingRlsLbClient.this.staleAgeNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeRefresh() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (CachingRlsLbClient.this.pendingCallCache.containsKey(this.request)) {
                    return;
                }
                ListenableFuture asyncCall = CachingRlsLbClient.this.asyncRlsCall(this.request);
                if (!asyncCall.isDone()) {
                    CachingRlsLbClient.this.pendingCallCache.put(this.request, new PendingCacheEntry(this.request, (ListenableFuture<RlsProtoData.RouteLookupResponse>)asyncCall));
                } else {
                    try {
                        RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)asyncCall.get();
                        CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, new DataCacheEntry(this.request, response));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        BackoffCacheEntry backoffEntry = new BackoffCacheEntry(this.request, Status.fromThrowable((Throwable)e), CachingRlsLbClient.this.backoffProvider.get());
                        CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, backoffEntry);
                    }
                }
            }
        }

        @VisibleForTesting
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper(String target) {
            for (LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper : this.childPolicyWrappers) {
                if (!childPolicyWrapper.getTarget().equals(target)) continue;
                return childPolicyWrapper;
            }
            throw new RuntimeException("Target not found:" + target);
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            for (LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper : this.childPolicyWrappers) {
                if (childPolicyWrapper.getState() == ConnectivityState.TRANSIENT_FAILURE) continue;
                return childPolicyWrapper;
            }
            return this.childPolicyWrappers.get(0);
        }

        String getHeaderData() {
            return this.response.getHeaderData();
        }

        int calcStringSize(String target) {
            return target.length() * 2 + 38;
        }

        @Override
        int getSizeBytes() {
            int targetSize = 0;
            for (String target : this.response.targets()) {
                targetSize += this.calcStringSize(target);
            }
            return targetSize + this.calcStringSize(this.response.getHeaderData()) + 16 + 128 + 16;
        }

        @Override
        boolean isExpired(long now) {
            return this.expireTime - now <= 0L;
        }

        boolean isStaled(long now) {
            return this.staleTime - now <= 0L;
        }

        @Override
        protected long getMinEvictionTime() {
            return this.minEvictionTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void cleanup() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                for (LbPolicyConfiguration.ChildPolicyWrapper policyWrapper : this.childPolicyWrappers) {
                    CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(policyWrapper);
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("response", (Object)this.response).add("expireTime", this.expireTime).add("staleTime", this.staleTime).add("childPolicyWrappers", this.childPolicyWrappers).toString();
        }
    }

    abstract class CacheEntry {
        protected final RlsProtoData.RouteLookupRequest request;

        CacheEntry(RlsProtoData.RouteLookupRequest request) {
            this.request = (RlsProtoData.RouteLookupRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        abstract int getSizeBytes();

        final boolean isExpired() {
            return this.isExpired(CachingRlsLbClient.this.ticker.read());
        }

        abstract boolean isExpired(long var1);

        abstract void cleanup();

        protected long getMinEvictionTime() {
            return 0L;
        }

        protected void triggerPendingRpcProcessing() {
            CachingRlsLbClient.this.helper.triggerPendingRpcProcessing();
        }
    }

    final class PendingCacheEntry {
        private final ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall;
        private final RlsProtoData.RouteLookupRequest request;
        private final BackoffPolicy backoffPolicy;

        PendingCacheEntry(RlsProtoData.RouteLookupRequest request, ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall) {
            this(request, pendingCall, null);
        }

        PendingCacheEntry(RlsProtoData.RouteLookupRequest request, @Nullable ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall, BackoffPolicy backoffPolicy) {
            this.request = (RlsProtoData.RouteLookupRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
            this.pendingCall = pendingCall;
            this.backoffPolicy = backoffPolicy == null ? CachingRlsLbClient.this.backoffProvider.get() : backoffPolicy;
            pendingCall.addListener(new Runnable(){

                @Override
                public void run() {
                    PendingCacheEntry.this.handleDoneFuture();
                }
            }, (Executor)CachingRlsLbClient.this.synchronizationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDoneFuture() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.pendingCallCache.remove(this.request);
                if (this.pendingCall.isCancelled()) {
                    return;
                }
                try {
                    this.transitionToDataEntry((RlsProtoData.RouteLookupResponse)this.pendingCall.get());
                }
                catch (Exception e) {
                    if (e instanceof Throttler.ThrottledException) {
                        this.transitionToBackOff(Status.RESOURCE_EXHAUSTED.withCause((Throwable)e));
                    }
                    this.transitionToBackOff(Status.fromThrowable((Throwable)e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToDataEntry(RlsProtoData.RouteLookupResponse routeLookupResponse) {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Transition to data cache: routeLookupResponse={0}", new Object[]{routeLookupResponse});
                CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, new DataCacheEntry(this.request, routeLookupResponse));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToBackOff(Status status) {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Transition to back off: status={0}", new Object[]{status});
                CachingRlsLbClient.this.linkedHashLruCache.cacheAndClean(this.request, new BackoffCacheEntry(this.request, status, this.backoffPolicy));
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).toString();
        }
    }

    static final class CachedRouteLookupResponse {
        @Nullable
        private final DataCacheEntry dataCacheEntry;
        @Nullable
        private final PendingCacheEntry pendingCacheEntry;
        @Nullable
        private final BackoffCacheEntry backoffCacheEntry;

        CachedRouteLookupResponse(DataCacheEntry dataCacheEntry, PendingCacheEntry pendingCacheEntry, BackoffCacheEntry backoffCacheEntry) {
            this.dataCacheEntry = dataCacheEntry;
            this.pendingCacheEntry = pendingCacheEntry;
            this.backoffCacheEntry = backoffCacheEntry;
            Preconditions.checkState((dataCacheEntry != null ^ pendingCacheEntry != null ^ backoffCacheEntry != null && (dataCacheEntry == null || pendingCacheEntry == null || backoffCacheEntry == null) ? 1 : 0) != 0, (Object)"Expected only 1 cache entry value provided");
        }

        static CachedRouteLookupResponse pendingResponse(PendingCacheEntry pendingEntry) {
            return new CachedRouteLookupResponse(null, pendingEntry, null);
        }

        static CachedRouteLookupResponse backoffEntry(BackoffCacheEntry backoffEntry) {
            return new CachedRouteLookupResponse(null, null, backoffEntry);
        }

        static CachedRouteLookupResponse dataEntry(DataCacheEntry dataEntry) {
            return new CachedRouteLookupResponse(dataEntry, null, null);
        }

        boolean hasData() {
            return this.dataCacheEntry != null;
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getChildPolicyWrapper();
        }

        @Nullable
        @VisibleForTesting
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper(String target) {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getChildPolicyWrapper(target);
        }

        @Nullable
        String getHeaderData() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getHeaderData();
        }

        boolean hasError() {
            return this.backoffCacheEntry != null;
        }

        boolean isPending() {
            return this.pendingCacheEntry != null;
        }

        @Nullable
        Status getStatus() {
            if (!this.hasError()) {
                return null;
            }
            return this.backoffCacheEntry.getStatus();
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            if (this.dataCacheEntry != null) {
                toStringHelper.add("dataCacheEntry", (Object)this.dataCacheEntry);
            }
            if (this.pendingCacheEntry != null) {
                toStringHelper.add("pendingCacheEntry", (Object)this.pendingCacheEntry);
            }
            if (this.backoffCacheEntry != null) {
                toStringHelper.add("backoffCacheEntry", (Object)this.backoffCacheEntry);
            }
            return toStringHelper.toString();
        }
    }

    private static final class RlsLbHelper
    extends ForwardingLoadBalancerHelper {
        final LoadBalancer.Helper helper;
        private ConnectivityState state;
        private LoadBalancer.SubchannelPicker picker;

        RlsLbHelper(LoadBalancer.Helper helper) {
            this.helper = helper;
        }

        protected LoadBalancer.Helper delegate() {
            return this.helper;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.state = newState;
            this.picker = newPicker;
            super.updateBalancingState(newState, newPicker);
        }

        void propagateRlsError() {
            this.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    if (picker != null) {
                        this.updateBalancingState(state, picker);
                    }
                }
            });
        }

        void triggerPendingRpcProcessing() {
            super.updateBalancingState(this.state, this.picker);
        }
    }
}

