/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.ClientContainer;
import io.joshworks.restclient.http.RestClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;

public class ClientBuilder {
    private CredentialsProvider credentialsProvider;
    private int maxTotal = 20;
    private String baseUrl = "";
    private Function<String, String> urlTransformer = url -> url;
    private Map<String, Object> defaultHeaders = new HashMap<String, Object>();
    private RequestConfig.Builder configBuilder = RequestConfig.custom();
    private List<HttpRequestInterceptor> requestInterceptors = new LinkedList<HttpRequestInterceptor>();
    private List<HttpResponseInterceptor> responseInterceptor = new LinkedList<HttpResponseInterceptor>();
    private final CookieStore cookieStore = new BasicCookieStore();

    ClientBuilder() {
    }

    public RestClient build() {
        try {
            RequestConfig clientConfig = this.configBuilder.build();
            PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager();
            syncConnectionManager.setMaxTotal(this.maxTotal);
            CloseableHttpClient syncClient = this.createSyncClient(clientConfig, (HttpClientConnectionManager)syncConnectionManager);
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
            PoolingNHttpClientConnectionManager asyncConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            asyncConnectionManager.setMaxTotal(this.maxTotal);
            CloseableHttpAsyncClient asyncClient = this.createAsyncClient(clientConfig, asyncConnectionManager);
            RestClient restClient = new RestClient(this.baseUrl, this.defaultHeaders, this.urlTransformer, asyncConnectionManager, syncConnectionManager, asyncClient, syncClient, this.cookieStore);
            ClientContainer.addClient(restClient);
            return restClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CloseableHttpAsyncClient createAsyncClient(RequestConfig clientConfig, PoolingNHttpClientConnectionManager manager) {
        HttpAsyncClientBuilder asyncBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(clientConfig).setDefaultCookieStore(this.cookieStore).setConnectionManager((NHttpClientConnectionManager)manager);
        return this.addInterceptors(asyncBuilder).build();
    }

    private CloseableHttpClient createSyncClient(RequestConfig clientConfig, HttpClientConnectionManager manager) {
        HttpClientBuilder syncBuilder = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setDefaultCookieStore(this.cookieStore).setDefaultCredentialsProvider(this.credentialsProvider).setConnectionManager(manager);
        return this.addInterceptors(syncBuilder).build();
    }

    private HttpClientBuilder addInterceptors(HttpClientBuilder builder) {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            builder.addInterceptorLast(httpRequestInterceptor);
        }
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptor) {
            builder.addInterceptorLast(httpResponseInterceptor);
        }
        return builder;
    }

    private HttpAsyncClientBuilder addInterceptors(HttpAsyncClientBuilder builder) {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            builder.addInterceptorLast(httpRequestInterceptor);
        }
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptor) {
            builder.addInterceptorLast(httpResponseInterceptor);
        }
        return builder;
    }

    public ClientBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ClientBuilder defaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
        return this;
    }

    public ClientBuilder followRedirect(boolean followRedirect) {
        this.configBuilder.setRedirectsEnabled(followRedirect);
        return this;
    }

    public ClientBuilder interceptor(HttpRequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
        return this;
    }

    public ClientBuilder interceptor(HttpResponseInterceptor interceptor) {
        this.responseInterceptor.add(interceptor);
        return this;
    }

    public ClientBuilder defaultHeader(String key, long value) {
        this.defaultHeaders.put(key, value);
        return this;
    }

    public ClientBuilder credentialProvider(CredentialsProvider provider) {
        this.credentialsProvider = provider;
        return this;
    }

    public ClientBuilder urlTransformer(Function<String, String> transformer) {
        this.urlTransformer = transformer;
        return this;
    }

    public ClientBuilder cookieSpec(String cookieSpec) {
        this.configBuilder.setCookieSpec(cookieSpec);
        return this;
    }

    public ClientBuilder proxy(HttpHost proxy) {
        this.configBuilder.setProxy(proxy);
        return this;
    }

    public ClientBuilder proxy(HttpHost proxy, Credentials credentials) {
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), credentials);
        return this.proxy(proxy);
    }

    public ClientBuilder timeout(int connectionTimeout, int readTimeout) {
        this.configBuilder.setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout);
        return this;
    }

    public ClientBuilder concurrency(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }
}

