/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.IdleConnectionMonitor;
import io.joshworks.restclient.http.RestClient;
import io.joshworks.restclient.http.utils.ClientStats;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContainer {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static final Map<String, RestClient> clients = new ConcurrentHashMap<String, RestClient>();
    private static final IdleConnectionMonitor monitor = new IdleConnectionMonitor(clients::values);

    private ClientContainer() {
        Runtime.getRuntime().addShutdownHook(new Thread(ClientContainer::shutdown));
    }

    static void addClient(RestClient client) {
        logger.info("New rest client created, id: " + client.id);
        clients.put(client.id, client);
    }

    static void removeClient(RestClient client) {
        logger.info("Rest client removed, id: " + client.id);
        clients.remove(client.id);
    }

    public static int size() {
        return clients.size();
    }

    public static Map<String, ClientStats> stats() {
        return clients.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, d -> ((RestClient)d.getValue()).stats()));
    }

    public static synchronized void shutdown() {
        for (Map.Entry<String, RestClient> clientEntry : clients.entrySet()) {
            logger.info("Shutting down rest client, id: " + clientEntry.getKey());
            try {
                clientEntry.getValue().close();
            }
            catch (Exception e) {
                logger.error("Failed to close client '" + clientEntry.getKey() + "'", (Throwable)e);
            }
        }
        monitor.shutdown();
    }
}

