/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.RestClient;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionMonitor
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IdleConnectionMonitor.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Supplier<Collection<RestClient>> clients;

    IdleConnectionMonitor(Supplier<Collection<RestClient>> clients) {
        this.clients = clients;
        super.setDaemon(true);
        super.setName("restclient-monitor");
        this.start();
    }

    void shutdown() {
        logger.info("Stopping idle client connection monitor");
        this.running.set(false);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.running.get()) {
            logger.warn("Monitor is already running");
            return;
        }
        this.running.set(true);
        try {
            logger.info("Starting idle connection monitor");
            while (!Thread.currentThread().isInterrupted() && this.running.get()) {
                IdleConnectionMonitor idleConnectionMonitor = this;
                synchronized (idleConnectionMonitor) {
                    this.wait(5000L);
                    this.clients.get().iterator().forEachRemaining(RestClient::closeIdleConnections);
                }
            }
        }
        catch (InterruptedException ex) {
            logger.warn("Idle client connection stopped abruptly");
            return;
        }
        logger.info("Idle client connection stopped gracefully");
    }
}

