/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.ClientBuilder;
import io.joshworks.restclient.http.ClientContainer;
import io.joshworks.restclient.http.ClientRequest;
import io.joshworks.restclient.http.HttpMethod;
import io.joshworks.restclient.http.utils.ClientStats;
import io.joshworks.restclient.request.GetRequest;
import io.joshworks.restclient.request.HttpRequestWithBody;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;

public class RestClient
implements Closeable {
    private static final int IDLE_CONNECTION_TIMEOUT = 30;
    public final String id;
    private final Function<String, String> urlTransformer;
    private final String baseUrl;
    private final PoolingNHttpClientConnectionManager asyncConnectionManager;
    private final PoolingHttpClientConnectionManager syncConnectionManager;
    private final Map<String, Object> defaultHeaders = new HashMap<String, Object>();
    private final CloseableHttpAsyncClient asyncClient;
    private final CloseableHttpClient syncClient;
    private final CookieStore cookieStore;

    RestClient(String baseUrl, Map<String, Object> defaultHeaders, Function<String, String> urlTransformer, PoolingNHttpClientConnectionManager asyncConnectionManager, PoolingHttpClientConnectionManager syncConnectionManager, CloseableHttpAsyncClient asyncClient, CloseableHttpClient syncClient, CookieStore cookieStore) {
        this.baseUrl = baseUrl;
        this.urlTransformer = urlTransformer;
        this.asyncConnectionManager = asyncConnectionManager;
        this.syncConnectionManager = syncConnectionManager;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.cookieStore = cookieStore;
        this.defaultHeaders.putAll(defaultHeaders);
        this.id = UUID.randomUUID().toString().substring(0, 8);
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public GetRequest get(String url) {
        return new GetRequest(new ClientRequest(HttpMethod.GET, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public GetRequest head(String url) {
        return new GetRequest(new ClientRequest(HttpMethod.HEAD, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody options(String url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.OPTIONS, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.POST, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.DELETE, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody patch(String url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.PATCH, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.PUT, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public CookieStore cookieStore() {
        return this.cookieStore;
    }

    public ClientStats stats() {
        return new ClientStats(this.syncConnectionManager.getTotalStats(), this.asyncConnectionManager.getTotalStats());
    }

    private String resolveUrl(String url) {
        return this.urlTransformer.apply(this.baseUrl) + url;
    }

    void closeIdleConnections() {
        this.asyncConnectionManager.closeExpiredConnections();
        this.asyncConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
        this.syncConnectionManager.closeExpiredConnections();
        this.syncConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        try {
            if (this.syncClient != null) {
                this.syncClient.close();
                this.syncConnectionManager.close();
            }
            if (this.asyncClient != null && this.asyncClient.isRunning()) {
                this.asyncClient.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ClientContainer.removeClient(this);
    }
}

