/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.request;

import io.joshworks.restclient.http.ClientRequest;
import io.joshworks.restclient.http.HttpResponse;
import io.joshworks.restclient.http.JsonNode;
import io.joshworks.restclient.http.async.Callback;
import io.joshworks.restclient.http.exceptions.RestClientException;
import io.joshworks.restclient.request.HttpRequest;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public abstract class BaseRequest {
    protected HttpRequest httpRequest;
    protected final ClientRequest clientRequest;

    protected BaseRequest(ClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse<String> asString() throws RestClientException {
        return this.clientRequest.request(this.httpRequest, String.class);
    }

    public CompletableFuture<HttpResponse<String>> asStringAsync() {
        return this.clientRequest.requestAsync(this.httpRequest, String.class);
    }

    public void asStringAsync(Callback<String> callback) {
        this.clientRequest.requestAsync(this.httpRequest, String.class, callback);
    }

    public HttpResponse<JsonNode> asJson() throws RestClientException {
        return this.clientRequest.request(this.httpRequest, JsonNode.class);
    }

    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync() {
        return this.clientRequest.requestAsync(this.httpRequest, JsonNode.class);
    }

    public Future<HttpResponse<JsonNode>> asJsonAsync(Callback<JsonNode> callback) {
        return this.clientRequest.requestAsync(this.httpRequest, JsonNode.class, callback);
    }

    public <T> HttpResponse<T> asObject(Class<T> responseClass) throws RestClientException {
        return this.clientRequest.request(this.httpRequest, responseClass);
    }

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<T> responseClass) {
        return this.clientRequest.requestAsync(this.httpRequest, responseClass);
    }

    public <T> Future<HttpResponse<T>> asObjectAsync(Class<T> responseClass, Callback<T> callback) {
        return this.clientRequest.requestAsync(this.httpRequest, responseClass, callback);
    }

    public HttpResponse<InputStream> asBinary() throws RestClientException {
        return this.clientRequest.request(this.httpRequest, InputStream.class);
    }

    public CompletableFuture<HttpResponse<InputStream>> asBinaryAsync() {
        return this.clientRequest.requestAsync(this.httpRequest, InputStream.class);
    }

    public Future<HttpResponse<InputStream>> asBinaryAsync(Callback<InputStream> callback) {
        return this.clientRequest.requestAsync(this.httpRequest, InputStream.class, callback);
    }
}

