/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.request.body;

import io.joshworks.restclient.http.ClientRequest;
import io.joshworks.restclient.request.BaseRequest;
import io.joshworks.restclient.request.HttpRequest;
import io.joshworks.restclient.request.body.Body;
import java.io.File;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class MultipartBody
extends BaseRequest
implements Body {
    private final MultipartEntityBuilder builder = MultipartEntityBuilder.create();

    public MultipartBody(HttpRequest httpRequest, ClientRequest config) {
        super(config);
        this.httpRequest = httpRequest;
    }

    public MultipartBody part(String name, String value) {
        return this.part(name, value, ContentType.TEXT_PLAIN.getMimeType());
    }

    public MultipartBody part(String name, Integer value) {
        return this.part(name, value, ContentType.TEXT_PLAIN.getMimeType());
    }

    public MultipartBody part(String name, Long value) {
        return this.part(name, value, ContentType.TEXT_PLAIN.getMimeType());
    }

    public MultipartBody part(String name, Boolean value) {
        return this.part(name, value, ContentType.TEXT_PLAIN.getMimeType());
    }

    public MultipartBody part(String name, Double value) {
        return this.part(name, value, ContentType.TEXT_PLAIN.getMimeType());
    }

    public MultipartBody part(String name, String value, String contentType) {
        this.builder.addTextBody(name, value, ContentType.parse((String)contentType));
        return this;
    }

    public MultipartBody part(String name, Integer value, String contentType) {
        this.builder.addTextBody(name, String.valueOf(value), ContentType.parse((String)contentType));
        return this;
    }

    public MultipartBody part(String name, Long value, String contentType) {
        this.builder.addTextBody(name, String.valueOf(value), ContentType.parse((String)contentType));
        return this;
    }

    public MultipartBody part(String name, Boolean value, String contentType) {
        this.builder.addTextBody(name, String.valueOf(value), ContentType.parse((String)contentType));
        return this;
    }

    public MultipartBody part(String name, Double value, String contentType) {
        this.builder.addTextBody(name, String.valueOf(value), ContentType.parse((String)contentType));
        return this;
    }

    public MultipartBody part(String name, File file) {
        this.builder.addBinaryBody(name, file);
        return this;
    }

    public MultipartBody part(String name, File file, String contentType) {
        this.builder.addBinaryBody(name, file, ContentType.parse((String)contentType), file.getName());
        return this;
    }

    public MultipartBody part(String name, InputStream inputStream, String fileName) {
        this.builder.addBinaryBody(name, inputStream, ContentType.APPLICATION_OCTET_STREAM, fileName);
        return this;
    }

    public MultipartBody part(String name, InputStream inputStream, String contentType, String fileName) {
        this.builder.addBinaryBody(name, inputStream, ContentType.parse((String)contentType), fileName);
        return this;
    }

    public MultipartBody part(String name, byte[] bytes, String fileName) {
        this.builder.addBinaryBody(name, bytes, ContentType.APPLICATION_OCTET_STREAM, fileName);
        return this;
    }

    public MultipartBody part(String name, byte[] bytes, String contentType, String fileName) {
        this.builder.addBinaryBody(name, bytes, ContentType.parse((String)contentType), fileName);
        return this;
    }

    public MultipartBody mode(HttpMultipartMode mode) {
        this.builder.setMode(mode);
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        return this.builder.build();
    }

    @Override
    public boolean implicitContentType() {
        return true;
    }
}

