/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1FieldSelectorAttributes;
import io.kubernetes.client.openapi.models.V1FieldSelectorRequirement;
import io.kubernetes.client.openapi.models.V1FieldSelectorRequirementBuilder;
import io.kubernetes.client.openapi.models.V1FieldSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1FieldSelectorAttributesFluent<A extends V1FieldSelectorAttributesFluent<A>>
extends BaseFluent<A> {
    private String rawSelector;
    private ArrayList<V1FieldSelectorRequirementBuilder> requirements;

    public V1FieldSelectorAttributesFluent() {
    }

    public V1FieldSelectorAttributesFluent(V1FieldSelectorAttributes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1FieldSelectorAttributes instance) {
        V1FieldSelectorAttributes v1FieldSelectorAttributes = instance = instance != null ? instance : new V1FieldSelectorAttributes();
        if (instance != null) {
            this.withRawSelector(instance.getRawSelector());
            this.withRequirements(instance.getRequirements());
        }
    }

    public String getRawSelector() {
        return this.rawSelector;
    }

    public A withRawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
        return (A)this;
    }

    public boolean hasRawSelector() {
        return this.rawSelector != null;
    }

    public A addToRequirements(int index, V1FieldSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList();
        }
        V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.requirements.size()) {
            this._visitables.get("requirements").add(builder);
            this.requirements.add(builder);
        } else {
            this._visitables.get("requirements").add(builder);
            this.requirements.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequirements(int index, V1FieldSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList();
        }
        V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.requirements.size()) {
            this._visitables.get("requirements").add(builder);
            this.requirements.add(builder);
        } else {
            this._visitables.get("requirements").add(builder);
            this.requirements.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequirements(V1FieldSelectorRequirement ... items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList();
        }
        for (V1FieldSelectorRequirement item : items) {
            V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
            this._visitables.get("requirements").add(builder);
            this.requirements.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequirements(Collection<V1FieldSelectorRequirement> items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList();
        }
        for (V1FieldSelectorRequirement item : items) {
            V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
            this._visitables.get("requirements").add(builder);
            this.requirements.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequirements(V1FieldSelectorRequirement ... items) {
        if (this.requirements == null) {
            return (A)this;
        }
        for (V1FieldSelectorRequirement item : items) {
            V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
            this._visitables.get("requirements").remove(builder);
            this.requirements.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequirements(Collection<V1FieldSelectorRequirement> items) {
        if (this.requirements == null) {
            return (A)this;
        }
        for (V1FieldSelectorRequirement item : items) {
            V1FieldSelectorRequirementBuilder builder = new V1FieldSelectorRequirementBuilder(item);
            this._visitables.get("requirements").remove(builder);
            this.requirements.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequirements(Predicate<V1FieldSelectorRequirementBuilder> predicate) {
        if (this.requirements == null) {
            return (A)this;
        }
        Iterator<V1FieldSelectorRequirementBuilder> each = this.requirements.iterator();
        Object visitables = this._visitables.get("requirements");
        while (each.hasNext()) {
            V1FieldSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1FieldSelectorRequirement> buildRequirements() {
        return this.requirements != null ? V1FieldSelectorAttributesFluent.build(this.requirements) : null;
    }

    public V1FieldSelectorRequirement buildRequirement(int index) {
        return this.requirements.get(index).build();
    }

    public V1FieldSelectorRequirement buildFirstRequirement() {
        return this.requirements.get(0).build();
    }

    public V1FieldSelectorRequirement buildLastRequirement() {
        return this.requirements.get(this.requirements.size() - 1).build();
    }

    public V1FieldSelectorRequirement buildMatchingRequirement(Predicate<V1FieldSelectorRequirementBuilder> predicate) {
        for (V1FieldSelectorRequirementBuilder item : this.requirements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequirement(Predicate<V1FieldSelectorRequirementBuilder> predicate) {
        for (V1FieldSelectorRequirementBuilder item : this.requirements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequirements(List<V1FieldSelectorRequirement> requirements) {
        if (this.requirements != null) {
            this._visitables.get("requirements").clear();
        }
        if (requirements != null) {
            this.requirements = new ArrayList();
            for (V1FieldSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        } else {
            this.requirements = null;
        }
        return (A)this;
    }

    public A withRequirements(V1FieldSelectorRequirement ... requirements) {
        if (this.requirements != null) {
            this.requirements.clear();
            this._visitables.remove("requirements");
        }
        if (requirements != null) {
            for (V1FieldSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public RequirementsNested<A> addNewRequirement() {
        return new RequirementsNested(-1, null);
    }

    public RequirementsNested<A> addNewRequirementLike(V1FieldSelectorRequirement item) {
        return new RequirementsNested(-1, item);
    }

    public RequirementsNested<A> setNewRequirementLike(int index, V1FieldSelectorRequirement item) {
        return new RequirementsNested(index, item);
    }

    public RequirementsNested<A> editRequirement(int index) {
        if (this.requirements.size() <= index) {
            throw new RuntimeException("Can't edit requirements. Index exceeds size.");
        }
        return this.setNewRequirementLike(index, this.buildRequirement(index));
    }

    public RequirementsNested<A> editFirstRequirement() {
        if (this.requirements.size() == 0) {
            throw new RuntimeException("Can't edit first requirements. The list is empty.");
        }
        return this.setNewRequirementLike(0, this.buildRequirement(0));
    }

    public RequirementsNested<A> editLastRequirement() {
        int index = this.requirements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requirements. The list is empty.");
        }
        return this.setNewRequirementLike(index, this.buildRequirement(index));
    }

    public RequirementsNested<A> editMatchingRequirement(Predicate<V1FieldSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requirements.size(); ++i) {
            if (!predicate.test(this.requirements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requirements. No match found.");
        }
        return this.setNewRequirementLike(index, this.buildRequirement(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1FieldSelectorAttributesFluent that = (V1FieldSelectorAttributesFluent)o;
        if (!Objects.equals(this.rawSelector, that.rawSelector)) {
            return false;
        }
        return Objects.equals(this.requirements, that.requirements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rawSelector, this.requirements, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rawSelector != null) {
            sb.append("rawSelector:");
            sb.append(this.rawSelector + ",");
        }
        if (this.requirements != null && !this.requirements.isEmpty()) {
            sb.append("requirements:");
            sb.append(this.requirements);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RequirementsNested<N>
    extends V1FieldSelectorRequirementFluent<RequirementsNested<N>>
    implements Nested<N> {
        V1FieldSelectorRequirementBuilder builder;
        int index;

        RequirementsNested(int index, V1FieldSelectorRequirement item) {
            this.index = index;
            this.builder = new V1FieldSelectorRequirementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1FieldSelectorAttributesFluent.this.setToRequirements(this.index, this.builder.build());
        }

        public N endRequirement() {
            return this.and();
        }
    }
}

