/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1MutatingWebhook;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.")
public class V1MutatingWebhookConfiguration
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    @Nullable
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_WEBHOOKS = "webhooks";
    @SerializedName(value="webhooks")
    @Nullable
    private List<V1MutatingWebhook> webhooks = new ArrayList<V1MutatingWebhook>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1MutatingWebhookConfiguration apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1MutatingWebhookConfiguration kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public V1MutatingWebhookConfiguration metadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1MutatingWebhookConfiguration webhooks(@Nullable List<V1MutatingWebhook> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public V1MutatingWebhookConfiguration addWebhooksItem(V1MutatingWebhook webhooksItem) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1MutatingWebhook>();
        }
        this.webhooks.add(webhooksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Webhooks is a list of webhooks and the affected resources and operations.")
    public List<V1MutatingWebhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(@Nullable List<V1MutatingWebhook> webhooks) {
        this.webhooks = webhooks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1MutatingWebhookConfiguration v1MutatingWebhookConfiguration = (V1MutatingWebhookConfiguration)o;
        return Objects.equals(this.apiVersion, v1MutatingWebhookConfiguration.apiVersion) && Objects.equals(this.kind, v1MutatingWebhookConfiguration.kind) && Objects.equals(this.metadata, v1MutatingWebhookConfiguration.metadata) && Objects.equals(this.webhooks, v1MutatingWebhookConfiguration.webhooks);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1MutatingWebhookConfiguration {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    webhooks: ").append(this.toIndentedString(this.webhooks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraywebhooks;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1MutatingWebhookConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1MutatingWebhookConfiguration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEBHOOKS) != null && !jsonObj.get(SERIALIZED_NAME_WEBHOOKS).isJsonNull() && (jsonArraywebhooks = jsonObj.getAsJsonArray(SERIALIZED_NAME_WEBHOOKS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_WEBHOOKS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `webhooks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEBHOOKS).toString()));
            }
            for (int i = 0; i < jsonArraywebhooks.size(); ++i) {
                V1MutatingWebhook.validateJsonElement(jsonArraywebhooks.get(i));
            }
        }
    }

    public static V1MutatingWebhookConfiguration fromJson(String jsonString) throws IOException {
        return (V1MutatingWebhookConfiguration)JSON.getGson().fromJson(jsonString, V1MutatingWebhookConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_WEBHOOKS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1MutatingWebhookConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1MutatingWebhookConfiguration.class));
            return new TypeAdapter<V1MutatingWebhookConfiguration>(){

                public void write(JsonWriter out, V1MutatingWebhookConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1MutatingWebhookConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1MutatingWebhookConfiguration.validateJsonElement(jsonElement);
                    return (V1MutatingWebhookConfiguration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

