/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ResourceHealth;
import io.kubernetes.client.openapi.models.V1ResourceHealthBuilder;
import io.kubernetes.client.openapi.models.V1ResourceHealthFluent;
import io.kubernetes.client.openapi.models.V1ResourceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ResourceStatusFluent<A extends V1ResourceStatusFluent<A>>
extends BaseFluent<A> {
    private String name;
    private ArrayList<V1ResourceHealthBuilder> resources;

    public V1ResourceStatusFluent() {
    }

    public V1ResourceStatusFluent(V1ResourceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ResourceStatus instance) {
        V1ResourceStatus v1ResourceStatus = instance = instance != null ? instance : new V1ResourceStatus();
        if (instance != null) {
            this.withName(instance.getName());
            this.withResources(instance.getResources());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToResources(int index, V1ResourceHealth item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    public A setToResources(int index, V1ResourceHealth item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    public A addToResources(V1ResourceHealth ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1ResourceHealth item : items) {
            V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A addAllToResources(Collection<V1ResourceHealth> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1ResourceHealth item : items) {
            V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A removeFromResources(V1ResourceHealth ... items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (V1ResourceHealth item : items) {
            V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResources(Collection<V1ResourceHealth> items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (V1ResourceHealth item : items) {
            V1ResourceHealthBuilder builder = new V1ResourceHealthBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResources(Predicate<V1ResourceHealthBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<V1ResourceHealthBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            V1ResourceHealthBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ResourceHealth> buildResources() {
        return this.resources != null ? V1ResourceStatusFluent.build(this.resources) : null;
    }

    public V1ResourceHealth buildResource(int index) {
        return this.resources.get(index).build();
    }

    public V1ResourceHealth buildFirstResource() {
        return this.resources.get(0).build();
    }

    public V1ResourceHealth buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public V1ResourceHealth buildMatchingResource(Predicate<V1ResourceHealthBuilder> predicate) {
        for (V1ResourceHealthBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<V1ResourceHealthBuilder> predicate) {
        for (V1ResourceHealthBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<V1ResourceHealth> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (V1ResourceHealth item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    public A withResources(V1ResourceHealth ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (V1ResourceHealth item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(V1ResourceHealth item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, V1ResourceHealth item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<V1ResourceHealthBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceStatusFluent that = (V1ResourceStatusFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends V1ResourceHealthFluent<ResourcesNested<N>>
    implements Nested<N> {
        V1ResourceHealthBuilder builder;
        int index;

        ResourcesNested(int index, V1ResourceHealth item) {
            this.index = index;
            this.builder = new V1ResourceHealthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ResourceStatusFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }
}

