/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta2AllocatedDeviceStatus;
import io.kubernetes.client.openapi.models.V1beta2AllocatedDeviceStatusBuilder;
import io.kubernetes.client.openapi.models.V1beta2AllocatedDeviceStatusFluent;
import io.kubernetes.client.openapi.models.V1beta2AllocationResult;
import io.kubernetes.client.openapi.models.V1beta2AllocationResultBuilder;
import io.kubernetes.client.openapi.models.V1beta2AllocationResultFluent;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimConsumerReference;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimConsumerReferenceBuilder;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimConsumerReferenceFluent;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1beta2ResourceClaimStatusFluent<A extends V1beta2ResourceClaimStatusFluent<A>>
extends BaseFluent<A> {
    private V1beta2AllocationResultBuilder allocation;
    private ArrayList<V1beta2AllocatedDeviceStatusBuilder> devices;
    private ArrayList<V1beta2ResourceClaimConsumerReferenceBuilder> reservedFor;

    public V1beta2ResourceClaimStatusFluent() {
    }

    public V1beta2ResourceClaimStatusFluent(V1beta2ResourceClaimStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta2ResourceClaimStatus instance) {
        V1beta2ResourceClaimStatus v1beta2ResourceClaimStatus = instance = instance != null ? instance : new V1beta2ResourceClaimStatus();
        if (instance != null) {
            this.withAllocation(instance.getAllocation());
            this.withDevices(instance.getDevices());
            this.withReservedFor(instance.getReservedFor());
        }
    }

    public V1beta2AllocationResult buildAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    public A withAllocation(V1beta2AllocationResult allocation) {
        this._visitables.remove("allocation");
        if (allocation != null) {
            this.allocation = new V1beta2AllocationResultBuilder(allocation);
            this._visitables.get("allocation").add(this.allocation);
        } else {
            this.allocation = null;
            this._visitables.get("allocation").remove(this.allocation);
        }
        return (A)this;
    }

    public boolean hasAllocation() {
        return this.allocation != null;
    }

    public AllocationNested<A> withNewAllocation() {
        return new AllocationNested(null);
    }

    public AllocationNested<A> withNewAllocationLike(V1beta2AllocationResult item) {
        return new AllocationNested(item);
    }

    public AllocationNested<A> editAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(null));
    }

    public AllocationNested<A> editOrNewAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(new V1beta2AllocationResultBuilder().build()));
    }

    public AllocationNested<A> editOrNewAllocationLike(V1beta2AllocationResult item) {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(item));
    }

    public A addToDevices(int index, V1beta2AllocatedDeviceStatus item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(builder);
            this.devices.add(index, builder);
        }
        return (A)this;
    }

    public A setToDevices(int index, V1beta2AllocatedDeviceStatus item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(builder);
            this.devices.set(index, builder);
        }
        return (A)this;
    }

    public A addToDevices(V1beta2AllocatedDeviceStatus ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (V1beta2AllocatedDeviceStatus item : items) {
            V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A addAllToDevices(Collection<V1beta2AllocatedDeviceStatus> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (V1beta2AllocatedDeviceStatus item : items) {
            V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A removeFromDevices(V1beta2AllocatedDeviceStatus ... items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (V1beta2AllocatedDeviceStatus item : items) {
            V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDevices(Collection<V1beta2AllocatedDeviceStatus> items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (V1beta2AllocatedDeviceStatus item : items) {
            V1beta2AllocatedDeviceStatusBuilder builder = new V1beta2AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDevices(Predicate<V1beta2AllocatedDeviceStatusBuilder> predicate) {
        if (this.devices == null) {
            return (A)this;
        }
        Iterator<V1beta2AllocatedDeviceStatusBuilder> each = this.devices.iterator();
        Object visitables = this._visitables.get("devices");
        while (each.hasNext()) {
            V1beta2AllocatedDeviceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta2AllocatedDeviceStatus> buildDevices() {
        return this.devices != null ? V1beta2ResourceClaimStatusFluent.build(this.devices) : null;
    }

    public V1beta2AllocatedDeviceStatus buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public V1beta2AllocatedDeviceStatus buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public V1beta2AllocatedDeviceStatus buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public V1beta2AllocatedDeviceStatus buildMatchingDevice(Predicate<V1beta2AllocatedDeviceStatusBuilder> predicate) {
        for (V1beta2AllocatedDeviceStatusBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDevice(Predicate<V1beta2AllocatedDeviceStatusBuilder> predicate) {
        for (V1beta2AllocatedDeviceStatusBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDevices(List<V1beta2AllocatedDeviceStatus> devices) {
        if (this.devices != null) {
            this._visitables.get("devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (V1beta2AllocatedDeviceStatus item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)this;
    }

    public A withDevices(V1beta2AllocatedDeviceStatus ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove("devices");
        }
        if (devices != null) {
            for (V1beta2AllocatedDeviceStatus item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(V1beta2AllocatedDeviceStatus item) {
        return new DevicesNested(-1, item);
    }

    public DevicesNested<A> setNewDeviceLike(int index, V1beta2AllocatedDeviceStatus item) {
        return new DevicesNested(index, item);
    }

    public DevicesNested<A> editDevice(int index) {
        if (this.devices.size() <= index) {
            throw new RuntimeException("Can't edit devices. Index exceeds size.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException("Can't edit first devices. The list is empty.");
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last devices. The list is empty.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<V1beta2AllocatedDeviceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching devices. No match found.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public A addToReservedFor(int index, V1beta2ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(index, builder);
        }
        return (A)this;
    }

    public A setToReservedFor(int index, V1beta2ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.set(index, builder);
        }
        return (A)this;
    }

    public A addToReservedFor(V1beta2ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1beta2ResourceClaimConsumerReference item : items) {
            V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A addAllToReservedFor(Collection<V1beta2ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1beta2ResourceClaimConsumerReference item : items) {
            V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A removeFromReservedFor(V1beta2ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (V1beta2ResourceClaimConsumerReference item : items) {
            V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromReservedFor(Collection<V1beta2ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (V1beta2ResourceClaimConsumerReference item : items) {
            V1beta2ResourceClaimConsumerReferenceBuilder builder = new V1beta2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromReservedFor(Predicate<V1beta2ResourceClaimConsumerReferenceBuilder> predicate) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        Iterator<V1beta2ResourceClaimConsumerReferenceBuilder> each = this.reservedFor.iterator();
        Object visitables = this._visitables.get("reservedFor");
        while (each.hasNext()) {
            V1beta2ResourceClaimConsumerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta2ResourceClaimConsumerReference> buildReservedFor() {
        return this.reservedFor != null ? V1beta2ResourceClaimStatusFluent.build(this.reservedFor) : null;
    }

    public V1beta2ResourceClaimConsumerReference buildReservedFor(int index) {
        return this.reservedFor.get(index).build();
    }

    public V1beta2ResourceClaimConsumerReference buildFirstReservedFor() {
        return this.reservedFor.get(0).build();
    }

    public V1beta2ResourceClaimConsumerReference buildLastReservedFor() {
        return this.reservedFor.get(this.reservedFor.size() - 1).build();
    }

    public V1beta2ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<V1beta2ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1beta2ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReservedFor(Predicate<V1beta2ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1beta2ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReservedFor(List<V1beta2ResourceClaimConsumerReference> reservedFor) {
        if (this.reservedFor != null) {
            this._visitables.get("reservedFor").clear();
        }
        if (reservedFor != null) {
            this.reservedFor = new ArrayList();
            for (V1beta2ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        } else {
            this.reservedFor = null;
        }
        return (A)this;
    }

    public A withReservedFor(V1beta2ResourceClaimConsumerReference ... reservedFor) {
        if (this.reservedFor != null) {
            this.reservedFor.clear();
            this._visitables.remove("reservedFor");
        }
        if (reservedFor != null) {
            for (V1beta2ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        }
        return (A)this;
    }

    public boolean hasReservedFor() {
        return this.reservedFor != null && !this.reservedFor.isEmpty();
    }

    public ReservedForNested<A> addNewReservedFor() {
        return new ReservedForNested(-1, null);
    }

    public ReservedForNested<A> addNewReservedForLike(V1beta2ResourceClaimConsumerReference item) {
        return new ReservedForNested(-1, item);
    }

    public ReservedForNested<A> setNewReservedForLike(int index, V1beta2ResourceClaimConsumerReference item) {
        return new ReservedForNested(index, item);
    }

    public ReservedForNested<A> editReservedFor(int index) {
        if (this.reservedFor.size() <= index) {
            throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editFirstReservedFor() {
        if (this.reservedFor.size() == 0) {
            throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(0, this.buildReservedFor(0));
    }

    public ReservedForNested<A> editLastReservedFor() {
        int index = this.reservedFor.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editMatchingReservedFor(Predicate<V1beta2ResourceClaimConsumerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reservedFor.size(); ++i) {
            if (!predicate.test(this.reservedFor.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reservedFor. No match found.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta2ResourceClaimStatusFluent that = (V1beta2ResourceClaimStatusFluent)o;
        if (!Objects.equals(this.allocation, that.allocation)) {
            return false;
        }
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.reservedFor, that.reservedFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocation, this.devices, this.reservedFor, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocation != null) {
            sb.append("allocation:");
            sb.append(String.valueOf(this.allocation) + ",");
        }
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(String.valueOf(this.devices) + ",");
        }
        if (this.reservedFor != null && !this.reservedFor.isEmpty()) {
            sb.append("reservedFor:");
            sb.append(this.reservedFor);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AllocationNested<N>
    extends V1beta2AllocationResultFluent<AllocationNested<N>>
    implements Nested<N> {
        V1beta2AllocationResultBuilder builder;

        AllocationNested(V1beta2AllocationResult item) {
            this.builder = new V1beta2AllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2ResourceClaimStatusFluent.this.withAllocation(this.builder.build());
        }

        public N endAllocation() {
            return this.and();
        }
    }

    public class DevicesNested<N>
    extends V1beta2AllocatedDeviceStatusFluent<DevicesNested<N>>
    implements Nested<N> {
        V1beta2AllocatedDeviceStatusBuilder builder;
        int index;

        DevicesNested(int index, V1beta2AllocatedDeviceStatus item) {
            this.index = index;
            this.builder = new V1beta2AllocatedDeviceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2ResourceClaimStatusFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }

    public class ReservedForNested<N>
    extends V1beta2ResourceClaimConsumerReferenceFluent<ReservedForNested<N>>
    implements Nested<N> {
        V1beta2ResourceClaimConsumerReferenceBuilder builder;
        int index;

        ReservedForNested(int index, V1beta2ResourceClaimConsumerReference item) {
            this.index = index;
            this.builder = new V1beta2ResourceClaimConsumerReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2ResourceClaimStatusFluent.this.setToReservedFor(this.index, this.builder.build());
        }

        public N endReservedFor() {
            return this.and();
        }
    }
}

