/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1VolumeNodeResources;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CSINodeDriver holds information about the specification of one CSI driver installed on a node")
public class V1CSINodeDriver {
    public static final String SERIALIZED_NAME_ALLOCATABLE = "allocatable";
    @SerializedName(value="allocatable")
    @Nullable
    private V1VolumeNodeResources allocatable;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NODE_I_D = "nodeID";
    @SerializedName(value="nodeID")
    @Nonnull
    private String nodeID;
    public static final String SERIALIZED_NAME_TOPOLOGY_KEYS = "topologyKeys";
    @SerializedName(value="topologyKeys")
    @Nullable
    private List<String> topologyKeys = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CSINodeDriver allocatable(@Nullable V1VolumeNodeResources allocatable) {
        this.allocatable = allocatable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VolumeNodeResources getAllocatable() {
        return this.allocatable;
    }

    public void setAllocatable(@Nullable V1VolumeNodeResources allocatable) {
        this.allocatable = allocatable;
    }

    public V1CSINodeDriver name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1CSINodeDriver nodeID(@Nonnull String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as \"node1\", but the storage system may refer to the same node as \"nodeA\". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. \"nodeA\" instead of \"node1\". This field is required.")
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(@Nonnull String nodeID) {
        this.nodeID = nodeID;
    }

    public V1CSINodeDriver topologyKeys(@Nullable List<String> topologyKeys) {
        this.topologyKeys = topologyKeys;
        return this;
    }

    public V1CSINodeDriver addTopologyKeysItem(String topologyKeysItem) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(topologyKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. \"company.com/zone\", \"company.com/region\"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.")
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public void setTopologyKeys(@Nullable List<String> topologyKeys) {
        this.topologyKeys = topologyKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSINodeDriver v1CSINodeDriver = (V1CSINodeDriver)o;
        return Objects.equals(this.allocatable, v1CSINodeDriver.allocatable) && Objects.equals(this.name, v1CSINodeDriver.name) && Objects.equals(this.nodeID, v1CSINodeDriver.nodeID) && Objects.equals(this.topologyKeys, v1CSINodeDriver.topologyKeys);
    }

    public int hashCode() {
        return Objects.hash(this.allocatable, this.name, this.nodeID, this.topologyKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSINodeDriver {\n");
        sb.append("    allocatable: ").append(this.toIndentedString(this.allocatable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeID: ").append(this.toIndentedString(this.nodeID)).append("\n");
        sb.append("    topologyKeys: ").append(this.toIndentedString(this.topologyKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CSINodeDriver is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CSINodeDriver` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATABLE) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATABLE).isJsonNull()) {
            V1VolumeNodeResources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ALLOCATABLE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NODE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOPOLOGY_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_TOPOLOGY_KEYS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TOPOLOGY_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `topologyKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOPOLOGY_KEYS).toString()));
        }
    }

    public static V1CSINodeDriver fromJson(String jsonString) throws IOException {
        return (V1CSINodeDriver)JSON.getGson().fromJson(jsonString, V1CSINodeDriver.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATABLE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_I_D);
        openapiFields.add(SERIALIZED_NAME_TOPOLOGY_KEYS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_NODE_I_D);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CSINodeDriver.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CSINodeDriver.class));
            return new TypeAdapter<V1CSINodeDriver>(){

                public void write(JsonWriter out, V1CSINodeDriver value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CSINodeDriver read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CSINodeDriver.validateJsonElement(jsonElement);
                    return (V1CSINodeDriver)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

