/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.")
public class V1HTTPIngressPath {
    public static final String SERIALIZED_NAME_BACKEND = "backend";
    @SerializedName(value="backend")
    @Nonnull
    private V1IngressBackend backend;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    @Nullable
    private String path;
    public static final String SERIALIZED_NAME_PATH_TYPE = "pathType";
    @SerializedName(value="pathType")
    @Nonnull
    private String pathType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1HTTPIngressPath backend(@Nonnull V1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(@Nonnull V1IngressBackend backend) {
        this.backend = backend;
    }

    public V1HTTPIngressPath path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional \"path\" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value \"Exact\" or \"Prefix\".")
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public V1HTTPIngressPath pathType(@Nonnull String pathType) {
        this.pathType = pathType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is   done on a path element by element basis. A path element refers is the   list of labels in the path split by the '/' separator. A request is a   match for path p if every p is an element-wise prefix of p of the   request path. Note that if the last element of the path is a substring   of the last element in request path, it is not a match (e.g. /foo/bar   matches /foo/bar/baz, but does not match /foo/barbaz). * ImplementationSpecific: Interpretation of the Path matching is up to   the IngressClass. Implementations can treat this as a separate PathType   or treat it identically to Prefix or Exact path types. Implementations are required to support all path types.")
    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(@Nonnull String pathType) {
        this.pathType = pathType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPIngressPath v1HTTPIngressPath = (V1HTTPIngressPath)o;
        return Objects.equals(this.backend, v1HTTPIngressPath.backend) && Objects.equals(this.path, v1HTTPIngressPath.path) && Objects.equals(this.pathType, v1HTTPIngressPath.pathType);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HTTPIngressPath {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString(this.pathType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1HTTPIngressPath is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1HTTPIngressPath` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        V1IngressBackend.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BACKEND));
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pathType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH_TYPE).toString()));
        }
    }

    public static V1HTTPIngressPath fromJson(String jsonString) throws IOException {
        return (V1HTTPIngressPath)JSON.getGson().fromJson(jsonString, V1HTTPIngressPath.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BACKEND);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_PATH_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BACKEND);
        openapiRequiredFields.add(SERIALIZED_NAME_PATH_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1HTTPIngressPath.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1HTTPIngressPath.class));
            return new TypeAdapter<V1HTTPIngressPath>(){

                public void write(JsonWriter out, V1HTTPIngressPath value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1HTTPIngressPath read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1HTTPIngressPath.validateJsonElement(jsonElement);
                    return (V1HTTPIngressPath)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

