/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.")
public class V1NamedRuleWithOperations {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    @Nullable
    private List<String> apiGroups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_API_VERSIONS = "apiVersions";
    @SerializedName(value="apiVersions")
    @Nullable
    private List<String> apiVersions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_OPERATIONS = "operations";
    @SerializedName(value="operations")
    @Nullable
    private List<String> operations = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESOURCE_NAMES = "resourceNames";
    @SerializedName(value="resourceNames")
    @Nullable
    private List<String> resourceNames = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private List<String> resources = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    @Nullable
    private String scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NamedRuleWithOperations apiGroups(@Nullable List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1NamedRuleWithOperations addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(@Nullable List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1NamedRuleWithOperations apiVersions(@Nullable List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public V1NamedRuleWithOperations addApiVersionsItem(String apiVersionsItem) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(apiVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public void setApiVersions(@Nullable List<String> apiVersions) {
        this.apiVersions = apiVersions;
    }

    public V1NamedRuleWithOperations operations(@Nullable List<String> operations) {
        this.operations = operations;
        return this;
    }

    public V1NamedRuleWithOperations addOperationsItem(String operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(@Nullable List<String> operations) {
        this.operations = operations;
    }

    public V1NamedRuleWithOperations resourceNames(@Nullable List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public V1NamedRuleWithOperations addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.")
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(@Nullable List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public V1NamedRuleWithOperations resources(@Nullable List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1NamedRuleWithOperations addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is a list of resources this rule applies to.  For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/_*' means all subresources of pods. '*_/scale' means all scale subresources. '*_/_*' means all resources and their subresources.  If wildcard is present, the validation rule will ensure resources do not overlap with each other.  Depending on the enclosing object, subresources might not be allowed. Required.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(@Nullable List<String> resources) {
        this.resources = resources;
    }

    public V1NamedRuleWithOperations scope(@Nullable String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".")
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamedRuleWithOperations v1NamedRuleWithOperations = (V1NamedRuleWithOperations)o;
        return Objects.equals(this.apiGroups, v1NamedRuleWithOperations.apiGroups) && Objects.equals(this.apiVersions, v1NamedRuleWithOperations.apiVersions) && Objects.equals(this.operations, v1NamedRuleWithOperations.operations) && Objects.equals(this.resourceNames, v1NamedRuleWithOperations.resourceNames) && Objects.equals(this.resources, v1NamedRuleWithOperations.resources) && Objects.equals(this.scope, v1NamedRuleWithOperations.scope);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resourceNames, this.resources, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamedRuleWithOperations {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    apiVersions: ").append(this.toIndentedString(this.apiVersions)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NamedRuleWithOperations is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NamedRuleWithOperations` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSIONS) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPERATIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `operations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceNames` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static V1NamedRuleWithOperations fromJson(String jsonString) throws IOException {
        return (V1NamedRuleWithOperations)JSON.getGson().fromJson(jsonString, V1NamedRuleWithOperations.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_GROUPS);
        openapiFields.add(SERIALIZED_NAME_API_VERSIONS);
        openapiFields.add(SERIALIZED_NAME_OPERATIONS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_NAMES);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NamedRuleWithOperations.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NamedRuleWithOperations.class));
            return new TypeAdapter<V1NamedRuleWithOperations>(){

                public void write(JsonWriter out, V1NamedRuleWithOperations value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NamedRuleWithOperations read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NamedRuleWithOperations.validateJsonElement(jsonElement);
                    return (V1NamedRuleWithOperations)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

