/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume")
public class V1ScaleIOPersistentVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    @Nullable
    private String fsType;
    public static final String SERIALIZED_NAME_GATEWAY = "gateway";
    @SerializedName(value="gateway")
    @Nonnull
    private String gateway;
    public static final String SERIALIZED_NAME_PROTECTION_DOMAIN = "protectionDomain";
    @SerializedName(value="protectionDomain")
    @Nullable
    private String protectionDomain;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    @Nonnull
    private V1SecretReference secretRef;
    public static final String SERIALIZED_NAME_SSL_ENABLED = "sslEnabled";
    @SerializedName(value="sslEnabled")
    @Nullable
    private Boolean sslEnabled;
    public static final String SERIALIZED_NAME_STORAGE_MODE = "storageMode";
    @SerializedName(value="storageMode")
    @Nullable
    private String storageMode;
    public static final String SERIALIZED_NAME_STORAGE_POOL = "storagePool";
    @SerializedName(value="storagePool")
    @Nullable
    private String storagePool;
    public static final String SERIALIZED_NAME_SYSTEM = "system";
    @SerializedName(value="system")
    @Nonnull
    private String system;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    @Nullable
    private String volumeName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ScaleIOPersistentVolumeSource fsType(@Nullable String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\"")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(@Nullable String fsType) {
        this.fsType = fsType;
    }

    public V1ScaleIOPersistentVolumeSource gateway(@Nonnull String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="gateway is the host address of the ScaleIO API Gateway.")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(@Nonnull String gateway) {
        this.gateway = gateway;
    }

    public V1ScaleIOPersistentVolumeSource protectionDomain(@Nullable String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.")
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(@Nullable String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public V1ScaleIOPersistentVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ScaleIOPersistentVolumeSource secretRef(@Nonnull V1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(@Nonnull V1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1ScaleIOPersistentVolumeSource sslEnabled(@Nullable Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="sslEnabled is the flag to enable/disable SSL communication with Gateway, default false")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(@Nullable Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public V1ScaleIOPersistentVolumeSource storageMode(@Nullable String storageMode) {
        this.storageMode = storageMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.")
    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(@Nullable String storageMode) {
        this.storageMode = storageMode;
    }

    public V1ScaleIOPersistentVolumeSource storagePool(@Nullable String storagePool) {
        this.storagePool = storagePool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storagePool is the ScaleIO Storage Pool associated with the protection domain.")
    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(@Nullable String storagePool) {
        this.storagePool = storagePool;
    }

    public V1ScaleIOPersistentVolumeSource system(@Nonnull String system) {
        this.system = system;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="system is the name of the storage system as configured in ScaleIO.")
    public String getSystem() {
        return this.system;
    }

    public void setSystem(@Nonnull String system) {
        this.system = system;
    }

    public V1ScaleIOPersistentVolumeSource volumeName(@Nullable String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(@Nullable String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ScaleIOPersistentVolumeSource v1ScaleIOPersistentVolumeSource = (V1ScaleIOPersistentVolumeSource)o;
        return Objects.equals(this.fsType, v1ScaleIOPersistentVolumeSource.fsType) && Objects.equals(this.gateway, v1ScaleIOPersistentVolumeSource.gateway) && Objects.equals(this.protectionDomain, v1ScaleIOPersistentVolumeSource.protectionDomain) && Objects.equals(this.readOnly, v1ScaleIOPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1ScaleIOPersistentVolumeSource.secretRef) && Objects.equals(this.sslEnabled, v1ScaleIOPersistentVolumeSource.sslEnabled) && Objects.equals(this.storageMode, v1ScaleIOPersistentVolumeSource.storageMode) && Objects.equals(this.storagePool, v1ScaleIOPersistentVolumeSource.storagePool) && Objects.equals(this.system, v1ScaleIOPersistentVolumeSource.system) && Objects.equals(this.volumeName, v1ScaleIOPersistentVolumeSource.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ScaleIOPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    protectionDomain: ").append(this.toIndentedString(this.protectionDomain)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    sslEnabled: ").append(this.toIndentedString(this.sslEnabled)).append("\n");
        sb.append("    storageMode: ").append(this.toIndentedString(this.storageMode)).append("\n");
        sb.append("    storagePool: ").append(this.toIndentedString(this.storagePool)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ScaleIOPersistentVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ScaleIOPersistentVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROTECTION_DOMAIN) != null && !jsonObj.get(SERIALIZED_NAME_PROTECTION_DOMAIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROTECTION_DOMAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `protectionDomain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROTECTION_DOMAIN).toString()));
        }
        V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECRET_REF));
        if (jsonObj.get(SERIALIZED_NAME_STORAGE_MODE) != null && !jsonObj.get(SERIALIZED_NAME_STORAGE_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORAGE_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storageMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORAGE_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORAGE_POOL) != null && !jsonObj.get(SERIALIZED_NAME_STORAGE_POOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORAGE_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storagePool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORAGE_POOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SYSTEM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `system` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYSTEM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).toString()));
        }
    }

    public static V1ScaleIOPersistentVolumeSource fromJson(String jsonString) throws IOException {
        return (V1ScaleIOPersistentVolumeSource)JSON.getGson().fromJson(jsonString, V1ScaleIOPersistentVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_PROTECTION_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_SSL_ENABLED);
        openapiFields.add(SERIALIZED_NAME_STORAGE_MODE);
        openapiFields.add(SERIALIZED_NAME_STORAGE_POOL);
        openapiFields.add(SERIALIZED_NAME_SYSTEM);
        openapiFields.add(SERIALIZED_NAME_VOLUME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GATEWAY);
        openapiRequiredFields.add(SERIALIZED_NAME_SECRET_REF);
        openapiRequiredFields.add(SERIALIZED_NAME_SYSTEM);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ScaleIOPersistentVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ScaleIOPersistentVolumeSource.class));
            return new TypeAdapter<V1ScaleIOPersistentVolumeSource>(){

                public void write(JsonWriter out, V1ScaleIOPersistentVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ScaleIOPersistentVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ScaleIOPersistentVolumeSource.validateJsonElement(jsonElement);
                    return (V1ScaleIOPersistentVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

