/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxMetrics;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.function.Tuple2;
import java.util.List;

final class FluxMetricsFuseable<T>
extends FluxOperator<T, T>
implements Fuseable {
    final String name;
    final List<Tag> tags;
    @Nullable
    final MeterRegistry registryCandidate;

    FluxMetricsFuseable(Flux<? extends T> flux) {
        this(flux, null);
    }

    FluxMetricsFuseable(Flux<? extends T> flux, @Nullable MeterRegistry candidate) {
        super(flux);
        Tuple2<String, List<Tag>> nameAndTags = FluxMetrics.resolveNameAndTags(flux);
        this.name = nameAndTags.getT1();
        this.tags = nameAndTags.getT2();
        this.registryCandidate = candidate;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        CompositeMeterRegistry registry = Metrics.globalRegistry;
        if (this.registryCandidate != null) {
            registry = this.registryCandidate;
        }
        this.source.subscribe(new FluxMetrics.MicrometerFluxMetricsFuseableSubscriber<T>(actual, (MeterRegistry)registry, Clock.SYSTEM, this.name, this.tags));
    }
}

