/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.tools;

import io.milton.dns.Name;
import io.milton.dns.record.DClass;
import io.milton.dns.record.Message;
import io.milton.dns.record.Record;
import io.milton.dns.record.ReverseMap;
import io.milton.dns.record.SimpleResolver;
import io.milton.dns.record.TSIG;
import io.milton.dns.record.Type;
import java.io.IOException;
import java.net.InetAddress;

public class dig {
    static Name name = null;
    static int type = 1;
    static int dclass = 1;

    static void usage() {
        System.out.println("Usage: dig [@server] name [<type>] [<class>] [options]");
        System.exit(0);
    }

    static void doQuery(Message response, long ms) throws IOException {
        System.out.println("; java dig 0.0");
        System.out.println(response);
        System.out.println(";; Query time: " + ms + " ms");
    }

    static void doAXFR(Message response) throws IOException {
        System.out.println("; java dig 0.0 <> " + name + " axfr");
        if (response.isSigned()) {
            System.out.print(";; TSIG ");
            if (response.isVerified()) {
                System.out.println("ok");
            } else {
                System.out.println("failed");
            }
        }
        if (response.getRcode() != 0) {
            System.out.println(response);
            return;
        }
        Record[] records = response.getSectionArray(1);
        for (int i = 0; i < records.length; ++i) {
            System.out.println(records[i]);
        }
        System.out.print(";; done (");
        System.out.print(response.getHeader().getCount(1));
        System.out.print(" records, ");
        System.out.print(response.getHeader().getCount(3));
        System.out.println(" additional)");
    }

    public static void main(String[] argv) throws IOException {
        boolean printQuery;
        SimpleResolver res;
        block29: {
            String server = null;
            res = null;
            printQuery = false;
            if (argv.length < 1) {
                dig.usage();
            }
            try {
                String nameString;
                int arg = 0;
                if (argv[arg].startsWith("@")) {
                    server = argv[arg++].substring(1);
                }
                res = server != null ? new SimpleResolver(server) : new SimpleResolver();
                if ((nameString = argv[arg++]).equals("-x")) {
                    name = ReverseMap.fromAddress(argv[arg++]);
                    type = 12;
                    dclass = 1;
                } else {
                    name = Name.fromString(nameString, Name.root);
                    type = Type.value(argv[arg]);
                    if (type < 0) {
                        type = 1;
                    } else {
                        ++arg;
                    }
                    dclass = DClass.value(argv[arg]);
                    if (dclass < 0) {
                        dclass = 1;
                    } else {
                        ++arg;
                    }
                }
                while (argv[arg].startsWith("-") && argv[arg].length() > 1) {
                    switch (argv[arg].charAt(1)) {
                        case 'p': {
                            String portStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int port = Integer.parseInt(portStr);
                            if (port < 0 || port > 65536) {
                                System.out.println("Invalid port");
                                return;
                            }
                            res.setPort(port);
                            break;
                        }
                        case 'b': {
                            InetAddress addr;
                            String addrStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            try {
                                addr = InetAddress.getByName(addrStr);
                            }
                            catch (Exception e) {
                                System.out.println("Invalid address");
                                return;
                            }
                            res.setLocalAddress(addr);
                            break;
                        }
                        case 'k': {
                            String key = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            res.setTSIGKey(TSIG.fromString(key));
                            break;
                        }
                        case 't': {
                            res.setTCP(true);
                            break;
                        }
                        case 'i': {
                            res.setIgnoreTruncation(true);
                            break;
                        }
                        case 'e': {
                            String ednsStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int edns = Integer.parseInt(ednsStr);
                            if (edns < 0 || edns > 1) {
                                System.out.println("Unsupported EDNS level: " + edns);
                                return;
                            }
                            res.setEDNS(edns);
                            break;
                        }
                        case 'd': {
                            res.setEDNS(0, 0, 32768, null);
                            break;
                        }
                        case 'q': {
                            printQuery = true;
                            break;
                        }
                        default: {
                            System.out.print("Invalid option: ");
                            System.out.println(argv[arg]);
                        }
                    }
                    ++arg;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (name != null) break block29;
                dig.usage();
            }
        }
        if (res == null) {
            res = new SimpleResolver();
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message query = Message.newQuery(rec);
        if (printQuery) {
            System.out.println(query);
        }
        long startTime = System.currentTimeMillis();
        Message response = res.send(query);
        long endTime = System.currentTimeMillis();
        if (type == 252) {
            dig.doAXFR(response);
        } else {
            dig.doQuery(response, endTime - startTime);
        }
    }
}

