/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public class OAuth2TokenResponse
extends OAuthAccessTokenResponse {
    private String OAuth2URL;

    public String getOAuth2URL() {
        return this.OAuth2URL;
    }

    public void setOAuth2URL(String OAuth2URL) {
        this.OAuth2URL = OAuth2URL;
    }

    public String getAccessToken() {
        return this.getParam("access_token");
    }

    public Long getExpiresIn() {
        String value = this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }

    public String getRefreshToken() {
        return this.getParam("expires_in");
    }

    public String getScope() {
        return this.getParam("scope");
    }

    public OAuthToken getOAuthToken() {
        return new BasicOAuthToken(this.getAccessToken(), this.getExpiresIn(), this.getRefreshToken(), this.getScope());
    }

    protected void setBody(String body) throws OAuthProblemException {
        this.body = body.trim();
        if (this.isJson()) {
            try {
                this.parameters = JSONUtils.parseJSON((String)body);
            }
            catch (Throwable e) {
                throw OAuthProblemException.error((String)"unsupported_response_type", (String)"Invalid response! Response body is not application/json encoded");
            }
        } else {
            this.parameters = OAuthUtils.decodeForm((String)body);
        }
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void setResponseCode(int code) {
        this.responseCode = code;
    }

    private boolean isJson() {
        return this.body != null && this.body.startsWith("{");
    }
}

