/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.CalendarInvitations;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoEventResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.resource.ICalResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarInvitationsAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CalendarInvitationsAnnotationHandler.class);

    public CalendarInvitationsAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, CalendarInvitations.class, new Request.Method[0]);
    }

    public List<ICalResource> getCalendarInvitations(AnnoPrincipalResource parent) {
        ArrayList<ICalResource> invitations = new ArrayList<ICalResource>();
        Object source = parent.getSource();
        for (ControllerMethod cm : this.getMethods(source.getClass())) {
            try {
                Object o = this.invoke(cm, parent, new Object[0]);
                if (o == null) continue;
                if (o instanceof Collection) {
                    Collection l = (Collection)o;
                    for (Object childSource : l) {
                        this.createAndAdd(invitations, childSource, parent);
                    }
                    continue;
                }
                if (o.getClass().isArray()) {
                    Object[] arr;
                    for (Object childSource : arr = (Object[])o) {
                        this.createAndAdd(invitations, childSource, parent);
                    }
                    continue;
                }
                this.createAndAdd(invitations, o, parent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return invitations;
    }

    private void createAndAdd(List<ICalResource> invitations, Object childSource, AnnoPrincipalResource parent) {
        AnnoEventResource e = new AnnoEventResource(this.annoResourceFactory, childSource, parent);
        invitations.add(e);
    }
}

