/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPropertyAnnotationHandler<T>
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonPropertyAnnotationHandler.class);
    private T defaultValue;
    protected final String[] propertyNames;

    public CommonPropertyAnnotationHandler(Class annoClass, AnnotationResourceFactory outer) {
        super(outer, annoClass, new Request.Method[0]);
        this.propertyNames = new String[0];
    }

    public CommonPropertyAnnotationHandler(Class annoClass, AnnotationResourceFactory outer, String ... propNames) {
        super(outer, annoClass, new Request.Method[0]);
        this.propertyNames = propNames;
    }

    public T get(AnnoResource res) {
        Object source = res.getSource();
        log.trace("get.1: source type={}", source.getClass());
        try {
            ControllerMethod cm = this.getBestMethod(source.getClass(), null, null, Object.class);
            if (cm != null) {
                log.trace("get.2: found method={}", (Object)cm.method.getName());
                Object val = this.invoke(cm, res, new Object[0]);
                return (T)val;
            }
            log.trace("get.3: couldnt find annotated controllere method, look for method on the source object");
            Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
            if (m != null && m.getParameterTypes().length == 0) {
                log.trace("get.4: found method on source={}", (Object)m.getName());
                Object val = m.invoke(source, new Object[0]);
                return (T)val;
            }
            for (String propName : this.propertyNames) {
                Object s = this.attemptToReadProperty(source, propName);
                if (s == null) continue;
                log.trace("get.5: found value from source property={}", (Object)propName);
                return (T)s;
            }
            log.trace("get.6: couldnt get a value from annotated methods or properties, so look for a default value");
            return this.deriveDefaultValue(source);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.annoClass + " - " + source.getClass(), e);
        }
    }

    public void set(AnnoResource res, T newValue) {
        Object source = res.getSource();
        try {
            ControllerMethod cm = this.getBestMethod(source.getClass(), null, null, Void.TYPE);
            if (cm == null) {
                Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
                if (m != null) {
                    m.invoke(source, new Object[]{null});
                    return;
                }
                for (String propName : this.propertyNames) {
                    if (!this.attemptToSetProperty(source, propName, new String[0])) continue;
                    return;
                }
            } else {
                this.invoke(cm, res, newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.annoClass + " - " + source.getClass(), e);
        }
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected T deriveDefaultValue(Object source) {
        return this.getDefaultValue();
    }
}

