/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.annotated.NullSafeDateTimeConverter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean2;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.lang.StringUtils;

public class DataBinder {
    private final BeanUtilsBean bub;
    private final String[] dateFormats = new String[]{"dd/MM/yyyy", "dd/MM/yyyy HH:mm", "yyyy/MM/dd HH:mm"};
    private static final ThreadLocal<TimeZone> tlTimezone = new ThreadLocal();

    public static String getRawParam(Map<String, String> props, String name) {
        String s = props.get(name);
        return StringUtils.trimToNull((String)s);
    }

    public static void setTimeZoneForRequest(TimeZone tz) {
        tlTimezone.set(tz);
    }

    public static TimeZone getTimeZoneForRequest() {
        return tlTimezone.get();
    }

    public DataBinder() {
        ConvertUtilsBean2 convertUtilsBean = new ConvertUtilsBean2();
        NullSafeDateTimeConverter dtConverter = new NullSafeDateTimeConverter();
        dtConverter.setPatterns(this.dateFormats);
        convertUtilsBean.register((Converter)dtConverter, Date.class);
        BigDecimalConverter bdConverter = new BigDecimalConverter(null);
        convertUtilsBean.register((Converter)bdConverter, BigDecimal.class);
        this.bub = new BeanUtilsBean((ConvertUtilsBean)convertUtilsBean);
    }

    public void populate(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        this.populate(bean, properties, null);
    }

    public void populate(Object bean, Map properties, TimeZone timeZone) throws IllegalAccessException, InvocationTargetException {
        tlTimezone.set(timeZone);
        ArrayList keys = new ArrayList(properties.keySet());
        for (Object key : keys) {
            String propName;
            String k = key.toString();
            if (!k.endsWith("_checkbox") || properties.containsKey(propName = k.replace("_checkbox", ""))) continue;
            properties.put(propName, "");
        }
        this.bub.populate(bean, properties);
    }
}

