/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Root;
import io.milton.http.Request;
import io.milton.http.annotated.AnnotationHandler;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class RootAnnotationHandler
implements AnnotationHandler {
    private final List<ControllerMethod> controllerMethods = new ArrayList<ControllerMethod>();
    private final AnnotationResourceFactory outer;

    public RootAnnotationHandler(AnnotationResourceFactory outer) {
        this.outer = outer;
    }

    public Object execute(String host) {
        for (ControllerMethod cm : this.controllerMethods) {
            try {
                Object root = cm.method.getParameterTypes().length == 0 ? cm.method.invoke(cm.controller, new Object[0]) : cm.method.invoke(cm.controller, host);
                if (root == null) continue;
                return root;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void parseController(Object controller) {
        for (Method m : controller.getClass().getMethods()) {
            Root a = m.getAnnotation(Root.class);
            if (a == null) continue;
            ControllerMethod cm = new ControllerMethod(controller, m, null, null);
            this.controllerMethods.add(cm);
        }
    }

    @Override
    public Request.Method[] getSupportedMethods() {
        return null;
    }

    @Override
    public boolean isCompatible(Object source) {
        return false;
    }

    @Override
    public List<ControllerMethod> getControllerMethods() {
        return this.controllerMethods;
    }

    @Override
    public Class getAnnoClass() {
        return Root.class;
    }
}

