/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.entity;

import io.milton.common.BufferingOutputStream;
import io.milton.common.ReadingException;
import io.milton.common.WritingException;
import io.milton.http.Response;
import io.milton.http.entity.GetableResourceEntity;
import io.milton.resource.GetableResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingGetableResourceEntity
extends GetableResourceEntity {
    private static final Logger log = LoggerFactory.getLogger(BufferingGetableResourceEntity.class);
    private final Long contentLength;
    private final int maxMemorySize;

    public BufferingGetableResourceEntity(GetableResource resource, Map<String, String> params, String contentType, Long contentLength, int maxMemorySize) {
        super(resource, null, params, contentType);
        this.contentLength = contentLength;
        this.maxMemorySize = maxMemorySize;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Response response, OutputStream outputStream) throws Exception {
        log.trace("buffering content...");
        BufferingOutputStream tempOut = new BufferingOutputStream(this.maxMemorySize);
        try {
            this.getResource().sendContent((OutputStream)tempOut, this.getRange(), this.getParams(), this.getContentType());
            tempOut.close();
        }
        catch (IOException ex) {
            tempOut.deleteTempFileIfExists();
            throw new RuntimeException("Exception generating buffered content", ex);
        }
        Long bufContentLength = tempOut.getSize();
        if (this.contentLength != null && !this.contentLength.equals(bufContentLength)) {
            throw new RuntimeException("Content Length specified by resource: " + this.contentLength + " is not equal to the size of content when generated: " + bufContentLength + " This error can be suppressed by setting the buffering property to whenNeeded or never");
        }
        response.setContentLengthHeader(bufContentLength);
        if (log.isTraceEnabled()) {
            log.trace("sending buffered content... " + tempOut.getSize() + " bytes contentLength=" + this.contentLength);
        }
        InputStream in = tempOut.getInputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)outputStream);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            log.warn("exception writing, client probably closed connection", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

