/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.GetableResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialGetHelper {
    private static final Logger log = LoggerFactory.getLogger(PartialGetHelper.class);
    private int maxMemorySize = 100000;

    public List<Range> getRanges(String rangeHeader) {
        if (rangeHeader == null || rangeHeader.length() == 0) {
            log.trace("getRanges: no range header");
            return null;
        }
        if (rangeHeader.startsWith("bytes=")) {
            rangeHeader = rangeHeader.substring(6);
            String[] arr = rangeHeader.split(",");
            ArrayList<Range> list = new ArrayList<Range>();
            for (String s : arr) {
                Range r = Range.parse((String)s);
                list.add(r);
            }
            if (log.isTraceEnabled()) {
                log.trace("getRanges: header: " + rangeHeader + " parsed ranges: " + list.size());
            }
            return list;
        }
        return null;
    }

    public void sendPartialContent(GetableResource resource, Request request, Response response, List<Range> ranges, Map<String, String> params, Http11ResponseHandler responseHandler) throws NotAuthorizedException, BadRequestException, IOException, NotFoundException {
        log.trace("sendPartialContent");
        if (ranges.size() == 1) {
            log.trace("partial get, single range");
            Range r = ranges.get(0);
            responseHandler.respondPartialContent(resource, response, request, params, r);
        } else {
            log.trace("partial get, multiple ranges");
            responseHandler.respondPartialContent(resource, response, request, params, ranges);
        }
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }
}

