/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class HmacUtils {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String calcShaHash(String data, String key) {
        String result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = Base64.encodeBase64URLSafeString((byte[])rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(HMAC_SHA1_ALGORITHM, e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(HMAC_SHA1_ALGORITHM, e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(HMAC_SHA1_ALGORITHM, e);
        }
        return result;
    }
}

