/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.template;

import io.milton.common.View;
import io.milton.http.HttpManager;
import io.milton.http.template.TemplateProcessor;
import io.milton.http.template.ViewResolver;
import io.milton.servlet.OutputStreamWrappingHttpServletResponse;
import io.milton.servlet.ServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class JspViewResolver
implements ViewResolver {
    private String basePath = "/templates/";
    private String theme = "bootstrap";
    private final ServletContext servletContext;

    public JspViewResolver(ServletContext servletContext) {
        if (servletContext == null) {
            throw new RuntimeException("Must have a servlet context");
        }
        this.servletContext = servletContext;
    }

    @Override
    public TemplateProcessor resolveView(View view) {
        String jspPath = this.basePath + view.getTemplateName() + ".jsp";
        RequestDispatcher rd = this.servletContext.getRequestDispatcher(jspPath);
        if (rd == null) {
            throw new RuntimeException("Template not found: jspPath=" + jspPath + " view template=" + view.getTemplateName());
        }
        return new JspTemplateProcessor(jspPath, rd);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public class JspTemplateProcessor
    implements TemplateProcessor {
        private final String jspPath;
        private final RequestDispatcher rd;

        public JspTemplateProcessor(String jspPath, RequestDispatcher rd) {
            this.jspPath = jspPath;
            this.rd = rd;
        }

        @Override
        public void execute(Map<String, Object> model, OutputStream out) {
            try {
                HttpServletRequest req = io.milton.servlet.ServletRequest.getRequest();
                OutputStreamWrappingHttpServletResponse resp = new OutputStreamWrappingHttpServletResponse(ServletResponse.getResponse(), out);
                if (!model.containsKey("theme")) {
                    model.put("theme", JspViewResolver.this.theme);
                }
                String path = HttpManager.request().getAbsolutePath();
                req.setAttribute("pagePath", (Object)path);
                req.setAttribute("model", model);
                this.rd.include((ServletRequest)req, (javax.servlet.ServletResponse)resp);
                resp.flushBuffer();
            }
            catch (ServletException e) {
                throw new RuntimeException(this.jspPath, e);
            }
            catch (IOException e) {
                throw new RuntimeException(this.jspPath, e);
            }
        }
    }
}

