/*
 * Decompiled with CFR 0.152.
 */
package io.milton.property;

import io.milton.annotations.BeanProperty;
import io.milton.annotations.BeanPropertyResource;
import io.milton.http.AclUtils;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.property.BeanPropertySource;
import io.milton.property.PropertyAuthoriser;
import io.milton.resource.AccessControlledResource;
import io.milton.resource.Resource;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyAuthoriser
implements PropertyAuthoriser {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertyAuthoriser.class);
    private final BeanPropertySource beanPropertySource;
    private final PropertyAuthoriser wrapped;

    public BeanPropertyAuthoriser(BeanPropertySource beanPropertySource, PropertyAuthoriser wrapped) {
        this.beanPropertySource = beanPropertySource;
        this.wrapped = wrapped;
    }

    @Override
    public Set<PropertyAuthoriser.CheckResult> checkPermissions(Request request, Request.Method method, PropertyAuthoriser.PropertyPermission perm, Set<QName> fields, Resource resource) {
        log.trace("checkPermissions");
        HashSet<PropertyAuthoriser.CheckResult> results = null;
        BeanPropertyResource anno = this.beanPropertySource.getAnnotation(resource);
        if (anno == null) {
            return results;
        }
        if (!(resource instanceof AccessControlledResource)) {
            return results;
        }
        AccessControlledResource acr = (AccessControlledResource)resource;
        List actualPrivs = acr.getPriviledges(request.getAuthorization());
        if (actualPrivs == null) {
            log.trace("got null priviledges");
            return results;
        }
        if (log.isTraceEnabled()) {
            log.trace("found priviledges: " + actualPrivs + " from resource: " + acr.getClass());
        }
        for (QName name : fields) {
            AccessControlledResource.Priviledge role;
            if (!name.getNamespaceURI().equals(anno.value())) {
                log.debug("different namespace", (Object)anno.value(), (Object)name.getNamespaceURI());
                continue;
            }
            PropertyDescriptor pd = this.beanPropertySource.getPropertyDescriptor(resource, name.getLocalPart());
            if (pd == null || (role = this.getRequiredRole(name, resource, perm)) == null) continue;
            if (log.isTraceEnabled()) {
                log.trace("requires Priviledge: " + role + "  for field: " + name);
            }
            if (AclUtils.containsPriviledge((AccessControlledResource.Priviledge)role, (Iterable)actualPrivs)) continue;
            log.debug("not authorised to access field: " + name);
            if (results == null) {
                results = new HashSet<PropertyAuthoriser.CheckResult>();
            }
            results.add(new PropertyAuthoriser.CheckResult(name, Response.Status.SC_UNAUTHORIZED, "Not authorised to edit field: " + name.getLocalPart(), resource));
        }
        if (log.isTraceEnabled()) {
            if (results == null) {
                log.trace("no field errors");
            } else {
                log.trace("field errors: " + results.size());
            }
        }
        return results;
    }

    private AccessControlledResource.Priviledge getRequiredRole(QName name, Resource resource, PropertyAuthoriser.PropertyPermission propertyPermission) {
        PropertyDescriptor pd;
        if (log.isTraceEnabled()) {
            log.trace("getRequiredRole: " + name);
        }
        if ((pd = this.beanPropertySource.getPropertyDescriptor(resource, name.getLocalPart())) == null || pd.getReadMethod() == null) {
            log.trace("property not found, so use default role");
            return this.defaultRequiredRole(resource, propertyPermission);
        }
        BeanProperty anno = pd.getReadMethod().getAnnotation(BeanProperty.class);
        if (anno == null) {
            log.trace("no annotation");
            return this.defaultRequiredRole(resource, propertyPermission);
        }
        log.trace("got annotation");
        if (propertyPermission == PropertyAuthoriser.PropertyPermission.READ) {
            return anno.readRole();
        }
        return anno.writeRole();
    }

    private AccessControlledResource.Priviledge defaultRequiredRole(Resource resource, PropertyAuthoriser.PropertyPermission propertyPermission) {
        if (propertyPermission == PropertyAuthoriser.PropertyPermission.READ) {
            return AccessControlledResource.Priviledge.READ;
        }
        return AccessControlledResource.Priviledge.WRITE;
    }
}

