/*
 * Decompiled with CFR 0.152.
 */
package io.milton.proxy;

import io.milton.proxy.DataConn;
import io.milton.proxy.ProxyConn;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class ProxyLogConn
extends ProxyConn {
    protected PrintWriter lout;

    public ProxyLogConn(Socket clientSocket, String targetHost, int taretPort) {
        this.c1 = new DataConn(clientSocket);
        this.c2 = new DataConn(targetHost, taretPort);
        try {
            InetAddress rhost = clientSocket.getInetAddress();
            String rhostname = rhost.getHostName();
            this.lout = new PrintWriter(System.out);
            this.lout.println("// CLIENT: " + rhostname);
            this.lout.println("// TARGET: " + targetHost);
        }
        catch (Throwable T) {
            System.err.println("proxylogserver ERR: " + T.getMessage());
        }
    }

    @Override
    public void run() {
        super.run();
        if (this.lout != null) {
            this.lout.close();
        }
    }

    protected void finalize() {
        try {
            if (this.lout != null) {
                this.lout.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void exception(Throwable T) {
        try {
            System.err.println("EXCEPTION: " + T.getMessage());
            this.lout.println("EXCEPTION: " + T.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void log(boolean fromc1, byte[] d) {
        try {
            if (fromc1) {
                this.lout.print("c(\"");
            } else {
                this.lout.print("s(\"");
            }
            this.lout.print(ProxyLogConn.printableBytes(d));
            this.lout.println("\");");
            this.lout.flush();
        }
        catch (Throwable T) {
            this.exception(T);
        }
    }

    static String printableBytes(byte[] bytes) {
        if (bytes == null) {
            return "*NONE*";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            s.append((char)b);
            if (0 != ++i - 400 * (i / 400)) continue;
            s.append("\n");
        }
        String ss = s.toString();
        System.out.println(ss);
        return ss;
    }
}

