/*
 * Decompiled with CFR 0.152.
 */
package io.milton.restlet;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.restlet.RequestAdapter;
import io.milton.restlet.ResponseAdapter;
import io.milton.restlet.RestletEntityTransport;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.adapter.HttpResponse;

public class WebDavRestlet
extends Restlet {
    protected final ResourceFactory resourceFactory;
    protected HttpManager httpManager;

    public WebDavRestlet(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public WebDavRestlet(Context context, ResourceFactory resourceFactory) {
        super(context);
        this.resourceFactory = resourceFactory;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public HttpManager getHttpManager() {
        return this.httpManager;
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted()) {
            HttpManagerBuilder config = new HttpManagerBuilder();
            config.setMainResourceFactory(this.getResourceFactory());
            config.setEntityTransport(new RestletEntityTransport());
            this.httpManager = config.buildHttpManager();
        }
        super.start();
    }

    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            this.httpManager.shutdown();
        }
        super.stop();
    }

    public void handle(Request request, Response response) {
        if (!this.isStarted()) {
            return;
        }
        if (!(request instanceof HttpRequest)) {
            throw new IllegalArgumentException("HttpRequest required for WebDAV, not: " + request);
        }
        if (!(response instanceof HttpResponse)) {
            throw new IllegalArgumentException("HttpResponse required for WebDAV, not: " + response);
        }
        this.httpManager.process(new RequestAdapter((HttpRequest)request), new ResponseAdapter((HttpResponse)response));
    }
}

