/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.common.ContentTypeUtils;
import io.milton.common.RangeUtils;
import io.milton.http.Auth;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class StaticResource
implements GetableResource {
    private final File file;

    public StaticResource(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Static resource must be a file, this is a directory: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public String getUniqueId() {
        return this.file.getName() + "_ " + this.file.lastModified();
    }

    public int compareTo(Resource res) {
        return this.getName().compareTo(res.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            BufferedInputStream bin = new BufferedInputStream(fis);
            RangeUtils.writeRange((InputStream)bin, (Range)range, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)bin);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    public String getName() {
        return this.file.getName();
    }

    public Object authenticate(String user, String password) {
        return "ok";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "milton.io";
    }

    public Date getModifiedDate() {
        Date dt = new Date(this.file.lastModified());
        return dt;
    }

    public Long getContentLength() {
        return this.file.length();
    }

    public String getContentType(String preferredList) {
        String mime = ContentTypeUtils.findContentTypes((String)this.getName());
        String s = ContentTypeUtils.findAcceptableContentType((String)mime, (String)preferredList);
        return s;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        Long ll = 25920000L;
        return ll;
    }

    public LockToken getLockToken() {
        return null;
    }
}

