/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanEncoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;

public final class Encoder {
    private final HeaderEntry[] headerFields;
    private final HeaderEntry head = new HeaderEntry(-1, (CharSequence)AsciiString.EMPTY_STRING, (CharSequence)AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
    private final HuffmanEncoder huffmanEncoder = new HuffmanEncoder();
    private final byte hashMask;
    private int size;
    private int capacity;

    public Encoder(int maxHeaderTableSize) {
        this(maxHeaderTableSize, 16);
    }

    public Encoder(int maxHeaderTableSize, int arraySizeHint) {
        if (maxHeaderTableSize < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + maxHeaderTableSize);
        }
        this.capacity = maxHeaderTableSize;
        this.headerFields = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeader(ByteBuf out, CharSequence name, CharSequence value, boolean sensitive) {
        if (sensitive) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value, HpackUtil.IndexType.NEVER, nameIndex);
            return;
        }
        if (this.capacity == 0) {
            int staticTableIndex = StaticTable.getIndex(name, value);
            if (staticTableIndex == -1) {
                int nameIndex = StaticTable.getIndex(name);
                this.encodeLiteral(out, name, value, HpackUtil.IndexType.NONE, nameIndex);
            } else {
                Encoder.encodeInteger(out, 128, 7, staticTableIndex);
            }
            return;
        }
        int headerSize = HeaderField.sizeOf(name, value);
        if (headerSize > this.capacity) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value, HpackUtil.IndexType.NONE, nameIndex);
            return;
        }
        HeaderEntry headerField = this.getEntry(name, value);
        if (headerField != null) {
            int index = this.getIndex(headerField.index) + StaticTable.length;
            Encoder.encodeInteger(out, 128, 7, index);
        } else {
            int staticTableIndex = StaticTable.getIndex(name, value);
            if (staticTableIndex != -1) {
                Encoder.encodeInteger(out, 128, 7, staticTableIndex);
            } else {
                this.ensureCapacity(headerSize);
                this.encodeLiteral(out, name, value, HpackUtil.IndexType.INCREMENTAL, this.getNameIndex(name));
                this.add(name, value);
            }
        }
    }

    public void setMaxHeaderTableSize(ByteBuf out, int maxHeaderTableSize) {
        if (maxHeaderTableSize < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + maxHeaderTableSize);
        }
        if (this.capacity == maxHeaderTableSize) {
            return;
        }
        this.capacity = maxHeaderTableSize;
        this.ensureCapacity(0);
        Encoder.encodeInteger(out, 32, 5, maxHeaderTableSize);
    }

    public int getMaxHeaderTableSize() {
        return this.capacity;
    }

    private static void encodeInteger(ByteBuf out, int mask, int n, int i) {
        assert (n >= 0 && n <= 8) : "N: " + n;
        int nbits = 255 >>> 8 - n;
        if (i < nbits) {
            out.writeByte(mask | i);
        } else {
            out.writeByte(mask | nbits);
            int length = i - nbits;
            while ((length & 0xFFFFFF80) != 0) {
                out.writeByte(length & 0x7F | 0x80);
                length >>>= 7;
            }
            out.writeByte(length);
        }
    }

    private void encodeStringLiteral(ByteBuf out, CharSequence string) {
        int huffmanLength = this.huffmanEncoder.getEncodedLength(string);
        if (huffmanLength < string.length()) {
            Encoder.encodeInteger(out, 128, 7, huffmanLength);
            this.huffmanEncoder.encode(out, string);
        } else {
            Encoder.encodeInteger(out, 0, 7, string.length());
            if (string instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)string;
                out.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                out.writeCharSequence(string, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf out, CharSequence name, CharSequence value, HpackUtil.IndexType indexType, int nameIndex) {
        boolean nameIndexValid = nameIndex != -1;
        switch (indexType) {
            case INCREMENTAL: {
                Encoder.encodeInteger(out, 64, 6, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NONE: {
                Encoder.encodeInteger(out, 0, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NEVER: {
                Encoder.encodeInteger(out, 16, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!nameIndexValid) {
            this.encodeStringLiteral(out, name);
        }
        this.encodeStringLiteral(out, value);
    }

    private int getNameIndex(CharSequence name) {
        int index = StaticTable.getIndex(name);
        if (index == -1 && (index = this.getIndex(name)) >= 0) {
            index += StaticTable.length;
        }
        return index;
    }

    private void ensureCapacity(int headerSize) {
        int index;
        while (this.size + headerSize > this.capacity && (index = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0 ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    int size() {
        return this.size;
    }

    HeaderField getHeaderField(int index) {
        HeaderEntry entry = this.head;
        while (index-- >= 0) {
            entry = entry.before;
        }
        return entry;
    }

    private HeaderEntry getEntry(CharSequence name, CharSequence value) {
        if (this.length() == 0 || name == null || value == null) {
            return null;
        }
        int h = AsciiString.hashCode((CharSequence)name);
        int i = this.index(h);
        HeaderEntry e = this.headerFields[i];
        while (e != null) {
            if (e.hash == h && (HpackUtil.equalsConstantTime(name, e.name) & HpackUtil.equalsConstantTime(value, e.value)) != 0) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private int getIndex(CharSequence name) {
        if (this.length() == 0 || name == null) {
            return -1;
        }
        int h = AsciiString.hashCode((CharSequence)name);
        int i = this.index(h);
        HeaderEntry e = this.headerFields[i];
        while (e != null) {
            if (e.hash == h && HpackUtil.equalsConstantTime(name, e.name) != 0) {
                return this.getIndex(e.index);
            }
            e = e.next;
        }
        return -1;
    }

    private int getIndex(int index) {
        return index == -1 ? -1 : index - this.head.before.index + 1;
    }

    private void add(CharSequence name, CharSequence value) {
        HeaderEntry e;
        int headerSize = HeaderField.sizeOf(name, value);
        if (headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + headerSize > this.capacity) {
            this.remove();
        }
        int h = AsciiString.hashCode((CharSequence)name);
        int i = this.index(h);
        HeaderEntry old = this.headerFields[i];
        this.headerFields[i] = e = new HeaderEntry(h, name, value, this.head.before.index - 1, old);
        e.addBefore(this.head);
        this.size += headerSize;
    }

    private HeaderField remove() {
        HeaderEntry prev;
        if (this.size == 0) {
            return null;
        }
        HeaderEntry eldest = this.head.after;
        int h = eldest.hash;
        int i = this.index(h);
        HeaderEntry e = prev = this.headerFields[i];
        while (e != null) {
            HeaderEntry next = e.next;
            if (e == eldest) {
                if (prev == eldest) {
                    this.headerFields[i] = next;
                } else {
                    prev.next = next;
                }
                eldest.remove();
                this.size -= eldest.size();
                return eldest;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0;
    }

    private int index(int h) {
        return h & this.hashMask;
    }

    private static class HeaderEntry
    extends HeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int hash, CharSequence name, CharSequence value, int index, HeaderEntry next) {
            super(name, value);
            this.index = index;
            this.hash = hash;
            this.next = next;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        private void addBefore(HeaderEntry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

