/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.internal;

import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.exception.OMSRuntimeException;
import java.lang.reflect.Constructor;

public class MessagingAccessPointAdapter {
    private static final String pattern = "^openmessaging:.+://.+/.*$";

    public static MessagingAccessPoint getMessagingAccessPoint(String url, KeyValue properties) {
        MessagingAccessPointAdapter.checkDriverURL(url);
        String driverImpl = MessagingAccessPointAdapter.parseDriverImpl(url, properties);
        String accessPoints = MessagingAccessPointAdapter.parseAccessPoints(url);
        String namespace = MessagingAccessPointAdapter.parseNamespace(url);
        properties.put("oms.namespace", namespace);
        properties.put("oms.access.points", accessPoints);
        properties.put("oms.driver.impl", driverImpl);
        try {
            Class<?> driverImplClass = Class.forName(driverImpl);
            Constructor<?> constructor = driverImplClass.getConstructor(KeyValue.class);
            return (MessagingAccessPoint)constructor.newInstance(properties);
        }
        catch (Throwable e) {
            throw new OMSRuntimeException("-1", "Can't construct a MessagingAccessPoint instance from the given OMS driver url.", e);
        }
    }

    private static String parseNamespace(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private static String parseAccessPoints(String url) {
        return url.substring(url.indexOf("//") + 2, url.lastIndexOf("/"));
    }

    private static String parseDriverImpl(String url, KeyValue properties) {
        if (properties.containsKey("oms.driver.impl")) {
            return properties.getString("oms.driver.impl");
        }
        return "io.openmessaging." + url.split(":")[1] + ".MessagingAccessPointImpl";
    }

    private static void checkDriverURL(String url) {
        if (!url.matches(pattern)) {
            throw new OMSRuntimeException("-1", "The OMS driver url is illegal.");
        }
    }
}

