/*
 * Decompiled with CFR 0.152.
 */
package rx.android.schedulers;

import android.os.Handler;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.android.plugins.RxAndroidPlugins;
import rx.functions.Action0;
import rx.internal.schedulers.ScheduledAction;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class HandlerScheduler
extends Scheduler {
    private final Handler handler;

    public static HandlerScheduler from(Handler handler) {
        if (handler == null) {
            throw new NullPointerException("handler == null");
        }
        return new HandlerScheduler(handler);
    }

    HandlerScheduler(Handler handler) {
        this.handler = handler;
    }

    public Scheduler.Worker createWorker() {
        return new HandlerWorker(this.handler);
    }

    static class HandlerWorker
    extends Scheduler.Worker {
        private final Handler handler;
        private final CompositeSubscription compositeSubscription = new CompositeSubscription();

        HandlerWorker(Handler handler) {
            this.handler = handler;
        }

        public void unsubscribe() {
            this.compositeSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.compositeSubscription.isUnsubscribed();
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.compositeSubscription.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            action = RxAndroidPlugins.getInstance().getSchedulersHook().onSchedule(action);
            final ScheduledAction scheduledAction = new ScheduledAction(action);
            scheduledAction.addParent(this.compositeSubscription);
            this.compositeSubscription.add((Subscription)scheduledAction);
            this.handler.postDelayed((Runnable)scheduledAction, unit.toMillis(delayTime));
            scheduledAction.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    HandlerWorker.this.handler.removeCallbacks((Runnable)scheduledAction);
                }
            }));
            return scheduledAction;
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

