/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.SQLException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public abstract class BaseConnection
implements Connection {
    protected boolean autoCommit = true;
    protected int transactionIsolation = 8;
    protected int holdability = 1;
    protected Properties clientInfo = new Properties();
    protected int savePointId;

    protected BaseConnection() {
    }

    public static void throwSQLException(SQLException exception) throws java.sql.SQLException {
        if (exception instanceof SQLiteConstraintException) {
            throw new SQLIntegrityConstraintViolationException((Throwable)exception);
        }
        if (exception instanceof SQLiteCantOpenDatabaseException || exception instanceof SQLiteDatabaseCorruptException || exception instanceof SQLiteAccessPermException) {
            throw new SQLNonTransientException((Throwable)exception);
        }
        throw new java.sql.SQLException((Throwable)exception);
    }

    protected abstract void ensureTransaction();

    protected abstract void execSQL(String var1) throws java.sql.SQLException;

    @Override
    public void clearWarnings() throws java.sql.SQLException {
    }

    @Override
    public void close() throws java.sql.SQLException {
    }

    @Override
    public void commit() throws java.sql.SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public boolean getAutoCommit() throws java.sql.SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws java.sql.SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws java.sql.SQLException {
        return this.holdability;
    }

    @Override
    public int getTransactionIsolation() throws java.sql.SQLException {
        return this.transactionIsolation;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws java.sql.SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws java.sql.SQLException {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws java.sql.SQLException {
        return this.prepareStatement(sql, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws java.sql.SQLException {
        this.execSQL("release savepoint " + savepoint.getSavepointName());
    }

    @Override
    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        this.execSQL("rollback to savepoint " + savepoint.getSavepointName());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws java.sql.SQLException {
        this.autoCommit = autoCommit;
        this.ensureTransaction();
    }

    @Override
    public void setCatalog(String catalog) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws java.sql.SQLException {
        this.holdability = holdability;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException("cannot change readonly mode after db opened");
    }

    @Override
    public Savepoint setSavepoint() throws java.sql.SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws java.sql.SQLException {
        ++this.savePointId;
        if (name == null) {
            name = "sp" + String.valueOf(this.savePointId);
        }
        this.execSQL("savepoint " + name);
        return new DatabaseSavepoint(this.savePointId, name);
    }

    @Override
    public void setTransactionIsolation(int level) throws java.sql.SQLException {
        switch (level) {
            case 0: 
            case 2: 
            case 8: {
                this.execSQL("PRAGMA read_uncommitted = false");
                this.transactionIsolation = level;
                break;
            }
            case 1: {
                this.execSQL("PRAGMA read_uncommitted = true");
                this.transactionIsolation = level;
                break;
            }
            case 4: {
                throw new SQLFeatureNotSupportedException();
            }
            default: {
                throw new java.sql.SQLException("invalid isolation " + level);
            }
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws java.sql.SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int timeout) throws java.sql.SQLException {
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties != null) {
            this.clientInfo = properties;
        }
    }

    @Override
    public String getClientInfo(String name) throws java.sql.SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws java.sql.SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws java.sql.SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws java.sql.SQLException {
        return false;
    }

    private static class DatabaseSavepoint
    implements Savepoint {
        private final int id;
        private final String name;

        DatabaseSavepoint(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public int getSavepointId() throws java.sql.SQLException {
            return this.id;
        }

        @Override
        public String getSavepointName() throws java.sql.SQLException {
            return this.name;
        }
    }
}

